/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.events.rework;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import java.lang.reflect.Type;
import java.nio.channels.Channel;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.api.events.DiSkyEvent;
import net.itsthesky.disky.api.events.SimpleDiSkyEvent;
import net.itsthesky.disky.api.events.rework.BuiltEvent;
import net.itsthesky.disky.api.events.rework.EventBuilder;
import net.itsthesky.disky.api.events.rework.EventListExpressionRegistration;
import net.itsthesky.disky.api.events.rework.EventSingleExpressionRegistration;
import net.itsthesky.disky.api.events.rework.EventValueRegistration;
import net.itsthesky.disky.api.events.rework.InterfaceRegistration;
import net.itsthesky.disky.api.events.rework.RestValueRegistration;
import net.itsthesky.disky.api.skript.reflects.ReflectEventExpressionFactory;
import net.itsthesky.disky.core.SkriptUtils;
import org.bukkit.event.Cancellable;

public class EventRegistryFactory {
    private static final AtomicInteger EVENT_COUNT = new AtomicInteger(0);

    public static <T extends Event> EventBuilder<T> builder(Class<T> eventClass) {
        return new EventBuilder<T>(eventClass);
    }

    static <T extends Event> BuiltEvent<T> registerEvent(EventBuilder<T> builder) {
        try {
            Function<T, Object> mapper;
            String baseClassName = "net.itsthesky.disky.elements.events.generated.Generated" + builder.getJdaEventClass().getSimpleName();
            String diSkyEventClassName = baseClassName + "_" + EVENT_COUNT.incrementAndGet();
            String bukkitEventClassName = diSkyEventClassName + "$BukkitEvent";
            DynamicType.Builder<?> diskyEventBuilder = new ByteBuddy().subclass(TypeDescription.Generic.Builder.parameterizedType(DiSkyEvent.class, builder.getJdaEventClass()).build()).name(diSkyEventClassName).annotateType(AnnotationDescription.Builder.ofType(Name.class).define("value", builder.getName()).build()).annotateType(AnnotationDescription.Builder.ofType(Description.class).defineArray("value", builder.getDescriptionLines()).build()).annotateType(AnnotationDescription.Builder.ofType(Examples.class).defineArray("value", builder.getExampleLines()).build());
            if (builder.getChecker() != null) {
                diskyEventBuilder = diskyEventBuilder.defineMethod("checker", (Type)((Object)Predicate.class), 0).intercept(MethodDelegation.to(new PredicateInterceptor(builder.getChecker())));
            }
            if (builder.getLogChecker() != null) {
                diskyEventBuilder = diskyEventBuilder.defineMethod("logChecker", (Type)((Object)Predicate.class), 0).intercept(MethodDelegation.to(new PredicateInterceptor(builder.getLogChecker())));
            }
            Class<?> diSkyEventClass = diskyEventBuilder.make().load(DiSkyEvent.class.getClassLoader()).getLoaded();
            List<InterfaceRegistration<T, ?, ?, ?>> interfaces = builder.getInterfaces();
            DynamicType.Builder<SimpleDiSkyEvent> simpleEventClassBuilder = new ByteBuddy().subclass(SimpleDiSkyEvent.class).name(bukkitEventClassName);
            for (InterfaceRegistration<T, ?, ?, ?> interfaceRegistration : interfaces) {
                if (interfaceRegistration.getParameterTypeClass() == null) {
                    simpleEventClassBuilder = simpleEventClassBuilder.implement(interfaceRegistration.getInterfaceClass()).defineMethod(interfaceRegistration.getMethodName(), interfaceRegistration.getReturnTypeClass(), 1).intercept(MethodDelegation.to(new BasicFunctionInterceptor(interfaceRegistration.getFunction())));
                    continue;
                }
                simpleEventClassBuilder = simpleEventClassBuilder.implement(interfaceRegistration.getInterfaceClass()).defineMethod(interfaceRegistration.getMethodName(), interfaceRegistration.getReturnTypeClass(), 1).withParameters(interfaceRegistration.getParameterTypeClass()).intercept(MethodDelegation.to(new BasicFunctionInterceptor(interfaceRegistration.getFunction())));
            }
            if (builder.isCancellable()) {
                simpleEventClassBuilder = simpleEventClassBuilder.implement(new Type[]{Cancellable.class}).defineMethod("isCancelled", Boolean.TYPE, 1).intercept(MethodDelegation.to(new ComplexInterceptor((allArguments, instance) -> {
                    SimpleDiSkyEvent event = (SimpleDiSkyEvent)((Object)((Object)((Object)instance)));
                    Object jdaEvent = event.getJDAEvent();
                    return Objects.requireNonNull(builder.getIsCancelledMapper()).apply(jdaEvent);
                }))).defineMethod("setCancelled", Void.TYPE, 1).withParameters(Boolean.TYPE).intercept(MethodDelegation.to(new ComplexInterceptor((allArguments, instance) -> {
                    SimpleDiSkyEvent event = (SimpleDiSkyEvent)((Object)((Object)((Object)instance)));
                    Object jdaEvent = event.getJDAEvent();
                    Objects.requireNonNull(builder.getSetCancelledMapper()).accept(jdaEvent, (boolean)((Boolean)allArguments[0]));
                    return null;
                })));
            }
            Class<SimpleDiSkyEvent> bukkitEventClass = simpleEventClassBuilder.make().load(diSkyEventClass.getClassLoader()).getLoaded();
            for (EventSingleExpressionRegistration<T, ?> eventSingleExpressionRegistration : builder.getSingleExpressionRegistrations()) {
                Class<?> clazz = eventSingleExpressionRegistration.getExpressionClass();
                mapper = eventSingleExpressionRegistration.getExpressionMapper();
                ReflectEventExpressionFactory.registerSingleEventExpression(eventSingleExpressionRegistration.getPattern(), bukkitEventClass, clazz, simpleEvt -> mapper.apply(((SimpleDiSkyEvent)((Object)((Object)simpleEvt))).getJDAEvent()));
            }
            for (EventListExpressionRegistration<T, ?> eventListExpressionRegistration : builder.getListExpressionRegistrations()) {
                Class<?> clazz = eventListExpressionRegistration.getExpressionClass();
                mapper = eventListExpressionRegistration.getExpressionMapper();
                ReflectEventExpressionFactory.registerListEventExpression(eventListExpressionRegistration.getPattern(), bukkitEventClass, clazz, evt -> (Object[])mapper.apply(((SimpleDiSkyEvent)((Object)((Object)evt))).getJDAEvent()));
            }
            if (builder.isSkriptRegistered()) {
                DiSkyEvent.registerExternalEventClass(diSkyEventClass, bukkitEventClass);
                DiSkyEvent.register(builder.getName(), diSkyEventClass, bukkitEventClass, builder.getPatterns()).description(builder.getDescriptionLines());
            }
            SkriptUtils.registerBotValue(bukkitEventClass);
            boolean bl = builder.getValueRegistrations().stream().anyMatch(registration -> registration.getValueClass().equals(Channel.class));
            for (EventValueRegistration<T, ?> eventValueRegistration : builder.getValueRegistrations()) {
                boolean bl2;
                Class<?> valueClass = eventValueRegistration.getValueClass();
                Function<T, ?> mapper2 = eventValueRegistration.getMapper();
                int time = eventValueRegistration.getTime();
                SkriptUtils.registerValue(bukkitEventClass, valueClass, event -> {
                    SimpleDiSkyEvent rawEvent = (SimpleDiSkyEvent)((Object)((Object)event));
                    return mapper2.apply(rawEvent.getJDAEvent());
                }, time);
                if (bl2 || !Channel.class.isAssignableFrom(valueClass)) continue;
                SkriptUtils.registerValue(bukkitEventClass, Channel.class, event -> {
                    SimpleDiSkyEvent rawEvent = (SimpleDiSkyEvent)((Object)((Object)event));
                    return (Channel)mapper2.apply(rawEvent.getJDAEvent());
                }, time);
                bl2 = true;
            }
            for (RestValueRegistration<T, ?, ?> restValueRegistration : builder.getRestValueRegistrations()) {
                String codeName = restValueRegistration.getCodeName();
                Function<T, RestAction<?>> actionMapper = restValueRegistration.getActionMapper();
                Function<?, ?> resultMapper = restValueRegistration.getResultMapper();
                SkriptUtils.registerRawRestValue(codeName, bukkitEventClass, event -> actionMapper.apply(((SimpleDiSkyEvent)((Object)((Object)((Object)event)))).getJDAEvent()), resultMapper::apply);
            }
            if (builder.getAuthorMapper() != null) {
                SkriptUtils.registerAuthorValue(bukkitEventClass, event -> builder.getAuthorMapper().apply(event.getJDAEvent()));
            }
            return new BuiltEvent<T>(builder.getJdaEventClass(), diSkyEventClass, bukkitEventClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register event: " + builder.getName(), e);
        }
    }

    protected static class PredicateInterceptor {
        private final Predicate predicate;

        public PredicateInterceptor(Predicate predicate) {
            this.predicate = predicate;
        }

        @RuntimeType
        public Object intercept() {
            return this.predicate;
        }
    }

    protected static class BasicFunctionInterceptor<I, S extends Event, R> {
        private final BiFunction<I, S, R> function;

        public BasicFunctionInterceptor(BiFunction<I, S, R> function) {
            this.function = function;
        }

        @RuntimeType
        public Object intercept(@AllArguments Object[] allArguments, @This Object instance) {
            Object arg = allArguments.length > 0 ? allArguments[0] : null;
            SimpleDiSkyEvent event = (SimpleDiSkyEvent)((Object)instance);
            if (arg == null) {
                return this.function.apply(null, event.getJDAEvent());
            }
            return this.function.apply(arg, event.getJDAEvent());
        }
    }

    protected static class ComplexInterceptor {
        private final BiFunction<Object[], Object, Object> function;

        public ComplexInterceptor(BiFunction<Object[], Object, Object> function) {
            this.function = function;
        }

        @RuntimeType
        public Object intercept(@AllArguments Object[] allArguments, @This Object instance) {
            return this.function.apply(allArguments, instance);
        }
    }
}

