/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.modules;

import ch.njol.skript.SkriptAddon;
import java.io.File;
import java.net.URLClassLoader;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.modules.DiSkyModuleInfo;
import net.itsthesky.disky.api.modules.ModuleOrigin;
import org.skriptlang.skript.util.ClassLoader;

public abstract class DiSkyModule {
    private final DiSkyModuleInfo info;
    private final File moduleJar;
    private final ModuleOrigin origin;
    private URLClassLoader loader;

    public DiSkyModule(DiSkyModuleInfo info, File moduleJar) {
        this.info = info;
        this.moduleJar = moduleJar;
        this.origin = new ModuleOrigin(this);
    }

    public abstract void init(DiSky var1, SkriptAddon var2);

    @Deprecated(forRemoval=true)
    public String getVersion() {
        return this.info.version.toString();
    }

    @Deprecated(forRemoval=true)
    public String getName() {
        return this.info.name;
    }

    @Deprecated(forRemoval=true)
    public String getAuthor() {
        return this.info.author;
    }

    public DiSkyModuleInfo getModuleInfo() {
        return this.info;
    }

    public File getModuleJar() {
        return this.moduleJar;
    }

    public ModuleOrigin getOrigin() {
        return this.origin;
    }

    public URLClassLoader getLoader() {
        return this.loader;
    }

    public void shutdown() {
    }

    public DiSkyModule setLoader(URLClassLoader loader) {
        this.loader = loader;
        return this;
    }

    protected void loadClasses(String basePackage, String ... subPackages) {
        ClassLoader.builder().basePackage(basePackage).addSubPackages(subPackages).initialize(true).deep(true).build().loadClasses(this.getClass(), this.getModuleJar());
    }
}

