/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.modules;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class DiSkyModuleClassLoader
extends URLClassLoader {
    private final String originalPackage;
    private final String relocatedPackage;
    private final Map<String, Class<?>> loadedClasses = new ConcurrentHashMap();
    private final Set<String> processedJars = Collections.newSetFromMap(new ConcurrentHashMap());

    public DiSkyModuleClassLoader(URL[] urls2, ClassLoader parent, String originalPackage, String relocatedPackage) {
        super(urls2, parent);
        this.originalPackage = originalPackage;
        this.relocatedPackage = relocatedPackage;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.loadedClasses.get(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        if (name.startsWith(this.originalPackage)) {
            String relocatedName = name.replace(this.originalPackage, this.relocatedPackage);
            try {
                Class<?> relocatedClass = this.getParent().loadClass(relocatedName);
                this.loadedClasses.put(name, relocatedClass);
                return relocatedClass;
            }
            catch (ClassNotFoundException relocatedClass) {
                // empty catch block
            }
        }
        try {
            Class<?> c = super.loadClass(name, resolve);
            this.loadedClasses.put(name, c);
            return c;
        }
        catch (ClassNotFoundException e) {
            Class<?> dependencyClass = this.loadFromDependencies(name);
            if (dependencyClass != null) {
                this.loadedClasses.put(name, dependencyClass);
                return dependencyClass;
            }
            throw e;
        }
    }

    private Class<?> loadFromDependencies(String name) throws ClassNotFoundException {
        try {
            for (URL url : this.getURLs()) {
                String jarPath;
                if (!url.getProtocol().equals("file") || !url.getPath().endsWith(".jar") || !this.processedJars.add(jarPath = url.getPath())) continue;
                try (JarFile jarFile = new JarFile(new File(jarPath));){
                    this.analyzeJarDependencies(jarFile);
                }
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Error analyzing dependencies", e);
        }
        return null;
    }

    private void analyzeJarDependencies(JarFile jarFile) throws IOException {
        Attributes attributes;
        String classpath;
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (classpath = (attributes = manifest.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null) {
            for (String path : classpath.split(" ")) {
                try {
                    File dependency = new File(new File(jarFile.getName()).getParent(), path);
                    if (!dependency.exists()) continue;
                    this.addURL(dependency.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    public static DiSkyModuleClassLoader createWithDependencies(File moduleJar, ClassLoader parent, String originalPackage, String relocatedPackage) throws IOException {
        File[] libs;
        ArrayList<URL> urls2 = new ArrayList<URL>();
        urls2.add(moduleJar.toURI().toURL());
        File libDir = new File(moduleJar.getParentFile(), "lib");
        if (libDir.exists() && libDir.isDirectory() && (libs = libDir.listFiles((dir, name) -> name.endsWith(".jar"))) != null) {
            for (File lib : libs) {
                urls2.add(lib.toURI().toURL());
            }
        }
        return new DiSkyModuleClassLoader(urls2.toArray(new URL[0]), parent, originalPackage, relocatedPackage);
    }
}

