/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.modules;

import ch.njol.skript.SkriptAddon;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.modules.DiSkyModule;
import net.itsthesky.disky.api.modules.DiSkyModuleInfo;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ModuleManager {
    private final HashMap<String, DiSkyModule> modules;
    private final File moduleFolder;
    private final DiSky instance;
    private final SkriptAddon addon;

    public ModuleManager(File moduleFolder, DiSky instance, SkriptAddon addon) {
        this.instance = instance;
        this.addon = addon;
        this.modules = new HashMap();
        if (!moduleFolder.exists()) {
            moduleFolder.mkdirs();
        }
        this.moduleFolder = moduleFolder;
    }

    private DiSkyModule loadModule(File file) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InvalidConfigurationException {
        JarFile jf = new JarFile(file);
        JarEntry moduleFile = jf.getJarEntry("module.yml");
        String moduleYml = new BufferedReader(new InputStreamReader(jf.getInputStream(moduleFile))).lines().collect(Collectors.joining("\n"));
        YamlConfiguration config = new YamlConfiguration();
        config.loadFromString(moduleYml);
        DiSkyModuleInfo info = DiSkyModuleInfo.fromYaml(config);
        if (info == null) {
            this.getLogger().severe("The module '" + file.getName() + "' was made for an older (4.20 or below) version of DiSky and cannot be loaded.");
            this.getLogger().severe("Please update the module at https://patreon.disky.me/ or on the wiki page (https://disky.me/docs)!");
            return null;
        }
        if (DiSky.getVersion().isSmallerThan(info.requiredMinVersion)) {
            this.getLogger().severe("The module '" + info.name + "' v" + String.valueOf(info.version) + " by '" + info.author + "' requires at least DiSky v" + String.valueOf(info.requiredMinVersion) + " to work! (You're using v" + String.valueOf(DiSky.getVersion()) + ")");
            return null;
        }
        URL[] urls2 = new URL[]{new URL("jar:file:" + file.getAbsolutePath() + "!/")};
        URLClassLoader loader = new URLClassLoader(urls2, this.getClass().getClassLoader());
        Class<?> clazz = loader.loadClass(info.mainClass);
        Constructor<?> constructor = clazz.getDeclaredConstructor(DiSkyModuleInfo.class, File.class);
        return ((DiSkyModule)constructor.newInstance(info, file)).setLoader(loader);
    }

    public void loadModules() throws IOException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvalidConfigurationException {
        File[] modulesFile = this.moduleFolder.listFiles();
        assert (modulesFile != null);
        for (File moduleFile : modulesFile) {
            DiSkyModule module;
            if (moduleFile.isDirectory()) continue;
            if (!moduleFile.getName().endsWith(".jar")) {
                this.getLogger().warning("Skipping file '" + moduleFile.getPath() + "' as it's not a valid module file.");
                continue;
            }
            this.getLogger().warning("Loading module from file '" + moduleFile.getPath() + "'...");
            try {
                module = this.loadModule(moduleFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getLogger().severe("Unable to initialize module '" + moduleFile.getPath() + "'! Maybe a wrong Java version?");
                return;
            }
            if (module == null) continue;
            this.getLogger().info("Successfully loaded module '" + module.getModuleInfo().name + "' v" + String.valueOf(module.getModuleInfo().version) + " by '" + module.getModuleInfo().author + "'! Enabling ...");
            try {
                module.init(this.instance, this.addon);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.getLogger().severe("Failed to enable module '" + module.getModuleInfo().name + "' v" + String.valueOf(module.getModuleInfo().version) + " by '" + module.getModuleInfo().author + "':");
                continue;
            }
            this.modules.put(module.getModuleInfo().name, module);
            this.getLogger().info("Successfully enabled module '" + module.getModuleInfo().name + "'!");
        }
    }

    public List<DiSkyModule> getModules() {
        return new ArrayList<DiSkyModule>(this.modules.values());
    }

    public HashMap<String, DiSkyModule> getModulesMap() {
        return this.modules;
    }

    private Logger getLogger() {
        return this.instance.getLogger();
    }
}

