/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.parser.ParserInstance;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.itsthesky.disky.core.Debug;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EasyElement
extends Effect {
    public static boolean validate(Expression<?> expression) {
        return expression instanceof Variable;
    }

    public static <T> T parseSingle(Expression<T> expression, Event e, T defaultValue) {
        if (expression == null) {
            return defaultValue;
        }
        @Nullable Object value = expression.getSingle(e);
        return (T)(value == null ? defaultValue : value);
    }

    public static <T> T parseSingle(Expression<T> expression, Event e) {
        return EasyElement.parseSingle(expression, e, null);
    }

    protected void exception(Event event, Throwable throwable) {
        DiSkyRuntimeHandler.error((Exception)throwable);
    }

    public static void exception(Throwable throwable) {
        DiSkyRuntimeHandler.error((Exception)throwable);
    }

    public static <T> T[] parseList(Expression<T> expression, Event e, T[] defaultValues) {
        if (expression == null) {
            return defaultValues;
        }
        @Nullable Object[] values = expression.getArray(e);
        return values == null || values.length == 0 ? defaultValues : values;
    }

    public static boolean anyNull(Object from, Object ... objects) {
        boolean anyNull = Arrays.stream(objects).anyMatch(Objects::isNull);
        if (anyNull) {
            Debug.debug(from, Debug.Type.EMPTY_VALUE, "One of the provided value is null!");
        }
        return anyNull;
    }

    public static boolean validate(Expression<?> expression, boolean shouldBeList) {
        if (!EasyElement.validate(expression)) {
            Skript.error((String)("Invalid expression, require a variable: " + expression.toString(null, false)));
            return false;
        }
        return shouldBeList ? ((Variable)expression).isList() : expression.isSingle();
    }

    public static boolean containsInterfaces(@NotNull Class<?> clazz) {
        for (Class<? extends Event> c : EasyElement.getCurrentEvents()) {
            for (Class<?> i : c.getInterfaces()) {
                if (!clazz.isAssignableFrom(i)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean eventsMatch(@NotNull Predicate<Class<? extends Event>> predicate) {
        return Stream.of(EasyElement.getCurrentEvents()).anyMatch(predicate);
    }

    public static Class<? extends Event>[] getCurrentEvents() {
        return ParserInstance.get().getCurrentEvents();
    }

    public static boolean containsEvent(@NotNull Class<? extends Event> clazz) {
        return Arrays.asList(EasyElement.getCurrentEvents()).contains(clazz);
    }

    @SafeVarargs
    public static <T> boolean equalAny(T base, T ... entities) {
        return Arrays.stream(entities).anyMatch(o -> o == base);
    }

    public static boolean isChangerMode(Changer.ChangeMode mode) {
        return EasyElement.equalAny(mode, Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.RESET, Changer.ChangeMode.REMOVE_ALL);
    }

    public static boolean isValid(Object[] delta) {
        return delta != null && delta.length > 0 && delta[0] != null;
    }
}

