/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.skript.entries;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.KeyValueEntryData;

public class MutexEntryData<T>
extends EntryData<MutexEntry<T>> {
    private EntryValidator entryValidator;
    private KeyValueEntryData<T> valueEntryData;

    public MutexEntryData(String key, @Nullable T defaultValue, boolean optional, EntryValidator entryValidator, final Function<String, T> parser) {
        super(key, MutexEntry.ofValue(defaultValue), optional);
        this.entryValidator = entryValidator;
        this.valueEntryData = new KeyValueEntryData<T>(key, defaultValue, false){

            protected T getValue(@NotNull String value) {
                return parser.apply(value);
            }

            @NotNull
            public String getSeparator() {
                return ":";
            }
        };
    }

    public MutexEntry<T> getValue(@NotNull Node node) {
        if (node instanceof SimpleNode) {
            Object value = this.valueEntryData.getValue(node);
            return MutexEntry.ofValue(value);
        }
        if (node instanceof SectionNode) {
            @Nullable EntryContainer entry = this.entryValidator.validate((SectionNode)node);
            if (entry == null) {
                return MutexEntry.empty();
            }
            return MutexEntry.ofEntry(entry);
        }
        return MutexEntry.empty();
    }

    public boolean canCreateWith(@NotNull Node node) {
        if (node instanceof SectionNode) {
            String key = node.getKey();
            if (key == null) {
                return false;
            }
            key = ScriptLoader.replaceOptions((String)key);
            return this.getKey().equalsIgnoreCase(key);
        }
        return this.valueEntryData.canCreateWith(node);
    }

    public static class MutexEntry<T> {
        @Nullable
        private final T value;
        @Nullable
        private final EntryContainer entry;

        public static <T> MutexEntry<T> ofEntry(@NotNull EntryContainer entry) {
            return new MutexEntry<Object>(null, entry);
        }

        public static <T> MutexEntry<T> ofValue(@NotNull T value) {
            return new MutexEntry<T>(value, null);
        }

        public static <T> MutexEntry<T> empty() {
            return new MutexEntry<Object>(null, null);
        }

        private MutexEntry(@Nullable T value, @Nullable EntryContainer entry) {
            this.value = value;
            this.entry = entry;
        }

        @Nullable
        public T getValue() {
            return this.value;
        }

        @Nullable
        public EntryContainer getEntryContainer() {
            return this.entry;
        }

        public boolean isComplex() {
            return this.entry != null;
        }

        public boolean isValid() {
            return this.value != null || this.entry != null;
        }
    }
}

