/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.api.skript.reflects;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatchers;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.DiSkyRegistry;
import net.itsthesky.disky.api.skript.reflects.ReflectChangeableProperty;
import net.itsthesky.disky.api.skript.reflects.ReflectClassFactory;
import net.itsthesky.disky.api.skript.reflects.ReflectProperty;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public final class ReflectChangeablePropertyFactory {
    private static final AtomicInteger COUNT = new AtomicInteger(0);

    public static <F, T> void registerChangeable(String fromTypeName, String propertyName, Class<F> fromType, Class<T> toType, String property, Function<F, T> converter, Function<Changer.ChangeMode, Class<?>[]> acceptedChanges, BiFunction<F, ChangeData<T>, Void> changeApplier, @Nullable ReflectClassFactory.Documentation documentation) {
        try {
            DynamicType.Builder<ReflectChangeableProperty> builder = new ByteBuddy().redefine(ReflectChangeableProperty.class).name("net.itsthesky.diski.elements.reflects.ReflectChangeableProperty_" + COUNT.incrementAndGet());
            if (documentation != null) {
                builder = builder.annotateType(AnnotationDescription.Builder.ofType(Name.class).define("value", documentation.getName()).build()).annotateType(AnnotationDescription.Builder.ofType(Description.class).defineArray("value", documentation.getDescription()).build()).annotateType(AnnotationDescription.Builder.ofType(Examples.class).defineArray("value", documentation.getExamples()).build()).annotateType(AnnotationDescription.Builder.ofType(Since.class).defineArray("value", documentation.getSince()).build());
            }
            Class elementClass = builder.method(ElementMatchers.named("convert")).intercept(MethodDelegation.to(new ReflectClassFactory.SingleConvertMethodInterceptor<F, T>(converter))).method(ElementMatchers.named("getPropertyName")).intercept(MethodDelegation.to(new ReflectClassFactory.PropertyNameMethodInterceptor(propertyName))).method(ElementMatchers.named("acceptChange")).intercept(MethodDelegation.to(new AcceptChangeMethodInterceptor(acceptedChanges))).method(ElementMatchers.named("change")).intercept(MethodDelegation.to(new ChangeMethodInterceptor<F, T>(changeApplier))).make().load(ReflectProperty.class.getClassLoader()).getLoaded();
            DiSkyRegistry.registerProperty(elementClass, toType, property, fromTypeName);
            DiSky.debug("Registered changeable property expression: " + elementClass.getName() + " (" + fromTypeName + " -> " + toType.getSimpleName() + " via \"" + property + "\")");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <F, T> void registerChangeable(String fromTypeName, String propertyName, Class<F> fromType, Class<T> toType, String property, Function<F, T> converter, Function<Changer.ChangeMode, Class<?>[]> acceptedChanges, BiFunction<F, ChangeData<T>, Void> changeApplier) {
        ReflectChangeablePropertyFactory.registerChangeable(fromTypeName, propertyName, fromType, toType, property, converter, acceptedChanges, changeApplier, null);
    }

    public static class AcceptChangeMethodInterceptor {
        private final Function<Changer.ChangeMode, Class<?>[]> acceptedChanges;

        public AcceptChangeMethodInterceptor(Function<Changer.ChangeMode, Class<?>[]> acceptedChanges) {
            this.acceptedChanges = acceptedChanges;
        }

        @RuntimeType
        public Object intercept(Changer.ChangeMode mode) {
            return this.acceptedChanges.apply(mode);
        }
    }

    public static class ChangeMethodInterceptor<F, T> {
        private final BiFunction<F, ChangeData<T>, Void> changeApplier;

        public ChangeMethodInterceptor(BiFunction<F, ChangeData<T>, Void> changeApplier) {
            this.changeApplier = changeApplier;
        }

        @RuntimeType
        public Object intercept(@This SimplePropertyExpression<F, T> expr, @AllArguments Object[] args) {
            Event event = (Event)args[0];
            Object[] rawDelta = (Object[])args[1];
            Changer.ChangeMode mode = (Changer.ChangeMode)args[2];
            Expression sourceExpr = expr.getExpr();
            Object[] targets = sourceExpr.getArray(event);
            Object[] delta = rawDelta;
            for (Object target : targets) {
                ChangeData<Object> changeData = new ChangeData<Object>(delta, mode, event);
                this.changeApplier.apply(target, changeData);
            }
            return null;
        }
    }

    public static class ChangeData<T> {
        private final T[] delta;
        private final Changer.ChangeMode mode;
        private final Event event;

        public ChangeData(T[] delta, Changer.ChangeMode mode, Event event) {
            this.delta = delta;
            this.mode = mode;
            this.event = event;
        }

        @Nullable
        public T getFirstDelta() {
            return this.delta.length > 0 ? (T)this.delta[0] : null;
        }

        @Generated
        public T[] getDelta() {
            return this.delta;
        }

        @Generated
        public Changer.ChangeMode getMode() {
            return this.mode;
        }

        @Generated
        public Event getEvent() {
            return this.event;
        }
    }
}

