/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import ch.njol.skript.lang.TriggerItem;
import java.util.Arrays;
import java.util.List;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.events.guild.GuildReadyEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.events.session.ShutdownEvent;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.Compression;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.itsthesky.disky.BotApplication;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.events.rework.BotEvents;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class BotOptions {
    private String name;
    private String token;
    @Nullable
    private BotApplication application;
    private boolean forceReload;
    private boolean autoReconnect;
    private GatewayIntent[] intents;
    private CacheFlag[] flags;
    private Compression compression;
    private MemberCachePolicy policy;
    private List<TriggerItem> onReady;
    private List<TriggerItem> onGuildReady;
    private List<TriggerItem> onShutdown;

    public JDABuilder toBuilder() {
        return JDABuilder.createDefault(this.getToken()).setCompression(this.compression).setAutoReconnect(this.autoReconnect).enableIntents(Arrays.asList(this.getIntents())).enableCache(Arrays.asList(this.getFlags())).setMemberCachePolicy(this.policy);
    }

    public void runReady(ReadyEvent event) {
        if (this.getOnReady().isEmpty()) {
            return;
        }
        Event e = BotEvents.READY_EVENT.createBukkitInstance(event);
        TriggerItem.walk((TriggerItem)this.getOnReady().get(0), (Event)e);
    }

    public void runGuildReady(GuildReadyEvent event) {
        if (this.getOnGuildReady().isEmpty()) {
            return;
        }
        Event e = BotEvents.GUILD_READY_EVENT.createBukkitInstance(event);
        TriggerItem.walk((TriggerItem)this.getOnGuildReady().get(0), (Event)e);
    }

    public void runShutdown(ShutdownEvent event) {
        if (this.getOnShutdown().isEmpty()) {
            DiSky.debug("No shutdown event defined for bot " + this.getName());
            return;
        }
        Event e = BotEvents.SHUTDOWN_EVENT.createBukkitInstance(event);
        DiSky.debug("Running shutdown event for bot " + this.getName());
        TriggerItem.walk((TriggerItem)this.getOnShutdown().get(0), (Event)e);
    }

    public String getName() {
        return this.name;
    }

    public List<TriggerItem> getOnShutdown() {
        return this.onShutdown;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String text) {
        while (text.contains("\"\"")) {
            text = text.replace("\"\"", "\"");
        }
        if (text.startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1, text.length() - 1);
        }
        this.token = text;
    }

    public GatewayIntent[] getIntents() {
        return this.intents;
    }

    public void setIntents(GatewayIntent[] intents) {
        this.intents = intents;
    }

    public CacheFlag[] getFlags() {
        return this.flags;
    }

    public void setFlags(CacheFlag[] flags) {
        this.flags = flags;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public MemberCachePolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(MemberCachePolicy policy) {
        this.policy = policy;
    }

    public boolean forceReload() {
        return this.forceReload;
    }

    public void setForceReload(boolean forceReload) {
        this.forceReload = forceReload;
    }

    @Nullable
    public BotApplication getApplication() {
        return this.application;
    }

    public void setApplication(@Nullable BotApplication application) {
        this.application = application;
    }

    public List<TriggerItem> getOnReady() {
        return this.onReady;
    }

    public void setOnReady(List<TriggerItem> onReady) {
        this.onReady = onReady;
    }

    public List<TriggerItem> getOnGuildReady() {
        return this.onGuildReady;
    }

    public void setOnGuildReady(List<TriggerItem> onGuildReady) {
        this.onGuildReady = onGuildReady;
    }

    public void setOnShutdown(List<TriggerItem> onShutdown) {
        this.onShutdown = onShutdown;
    }

    public Bot asBot(JDA core, BotOptions options) {
        return new Bot(this.getName(), core, options, this.getApplication(), this.forceReload);
    }
}

