/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.NodeInformation;
import net.itsthesky.disky.api.skript.WaiterEffect;
import net.itsthesky.disky.core.Utils;

public final class Debug {
    public static boolean isEnabled() {
        return DiSky.getInstance().getConfig().getBoolean("developer-debug", false);
    }

    public static void debug(Object from, String name, String message2) {
        if (!Debug.isEnabled()) {
            return;
        }
        NodeInformation nodeInformation = Debug.retrieveNode(from);
        if (nodeInformation == null) {
            Debug.send("&e[DiSky Debug] &7" + name + " &8\u00bb &f" + message2);
        } else {
            Debug.send("&e[DiSky Debug] &b" + name + " &8\u00bb &f" + message2 + nodeInformation.getColoredDebugLabel());
        }
    }

    public static void debug(Object from, Type type, String message2) {
        Debug.debug(from, type.getName(), message2);
    }

    private static void send(String message2) {
        DiSky.getInstance().getServer().getConsoleSender().sendMessage(Utils.colored(message2));
    }

    private static NodeInformation retrieveNode(Object from) {
        if (from instanceof WaiterEffect) {
            return ((WaiterEffect)((Object)from)).getNode();
        }
        try {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = from.getClass().getDeclaredFields()) {
                if (!field.getType().equals(NodeInformation.class)) continue;
                field.setAccessible(true);
                return (NodeInformation)field.get(from);
            }
            for (Method method : methods = from.getClass().getDeclaredMethods()) {
                if (!method.getReturnType().equals(NodeInformation.class)) continue;
                method.setAccessible(true);
                return (NodeInformation)method.invoke(from, new Object[0]);
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    public static enum Type {
        INCOMPATIBLE_TYPE("Incompatible type"),
        EMPTY_VALUE("Null/not set/empty value"),
        EMPTY_LIST("Empty list"),
        INVALID_STATE("Invalid state"),
        CUSTOM("Custom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

