/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.util.Date;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDAInfo;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.EventListener;
import net.itsthesky.disky.api.events.rework.EventBuilder;
import net.itsthesky.disky.api.events.rework.EventCategory;
import net.itsthesky.disky.api.modules.DiSkyModule;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.Utils;
import net.itsthesky.disky.managers.ConfigManager;
import net.itsthesky.disky.managers.CoreEventListener;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DiSkyCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            sender.sendMessage(Utils.colored("&b------ &9DiSky v" + DiSky.getInstance().getDescription().getVersion() + " Help Page &b------"));
            sender.sendMessage(Utils.colored(""));
            sender.sendMessage(Utils.colored("&b/disky &7- &9Show this help page."));
            sender.sendMessage(Utils.colored("&b/disky docs [include time] [module name] &7- &9Generate the full documentation of DiSky, including or not event-value's time."));
            sender.sendMessage(Utils.colored("&b/disky eventdocs &7- &9Generate the documentation for the events."));
            sender.sendMessage(Utils.colored("&b/disky modules &7- &9Show the list of modules."));
            sender.sendMessage(Utils.colored("&b/disky bots &7- &9Show the list of loaded bots."));
            sender.sendMessage(Utils.colored("&b/disky bot <bot> &7- &9Show info about a specific bot."));
            sender.sendMessage(Utils.colored("&b/disky debug [sections] &7- &9Store the debug information inside the 'plugins/DiSky/debug.txt' file."));
            sender.sendMessage(Utils.colored("&b/disky reloadconfig &7- &9Reload DiSky's configuration"));
            sender.sendMessage(Utils.colored("&b/disky reload <module name> &7- &4&lBETA &9Reload a specific module."));
            sender.sendMessage(Utils.colored(""));
            return true;
        }
        if (args[0].equalsIgnoreCase("docs")) {
            boolean includeTime = args.length > 1 && args[1].equalsIgnoreCase("true");
            String moduleName = args.length > 2 ? args[2] : null;
            sender.sendMessage(Utils.colored("&b------ &9DiSky v" + DiSky.getInstance().getDescription().getVersion() + " Documentation &b------"));
            long before = System.currentTimeMillis();
            DiSky.getDocBuilder().generate(includeTime, moduleName);
            sender.sendMessage(Utils.colored("&b------ &aSuccess! Took &2" + (System.currentTimeMillis() - before) + "ms! &b------"));
            return true;
        }
        if (args[0].equalsIgnoreCase("debug")) {
            String[] desiredSections;
            sender.sendMessage(Utils.colored("&b------ &6Generating file ... &b------"));
            StringBuilder sb = new StringBuilder();
            sb.append("---- DiSky Debug File ----\n");
            sb.append("// I hopes you're all good my friend? :c\n\n");
            HashMap<String, Runnable> debugSections = new HashMap<String, Runnable>();
            debugSections.put("os", () -> {
                sb.append("== | OS Information\n\n");
                sb.append("Time: ").append(Date.now()).append("\n");
                sb.append("Memory: ").append(Utils.formatBytes(Runtime.getRuntime().totalMemory())).append("\n");
                sb.append("Free Memory: ").append(Utils.formatBytes(Runtime.getRuntime().freeMemory())).append("\n");
                sb.append("Used Memory: ").append(Utils.formatBytes(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())).append("\n");
                sb.append("Max Memory: ").append(Utils.formatBytes(Runtime.getRuntime().maxMemory())).append("\n");
                sb.append("Operating System: ").append(System.getProperty("os.name")).append("\n");
                sb.append("\n");
            });
            debugSections.put("server", () -> {
                sb.append("== | Server Information\n\n");
                sb.append("Software: ").append(Bukkit.getVersion()).append("\n");
                sb.append("Bukkit Version: ").append(Bukkit.getBukkitVersion()).append("\n");
                sb.append("Installed Plugins: ").append(Bukkit.getPluginManager().getPlugins().length).append("\n");
                for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                    sb.append("  - ").append(plugin.getName()).append(" v").append(plugin.getDescription().getVersion()).append("\n");
                }
                sb.append("\n");
            });
            debugSections.put("disky", () -> {
                sb.append("== | DiSky Information\n\n");
                sb.append("Version: ").append(DiSky.getInstance().getDescription().getVersion()).append("\n");
                sb.append("JDA Version: ").append(JDAInfo.VERSION).append("\n");
                sb.append("Main JDA Class: ").append(JDA.class.getName()).append("\n");
                sb.append("Loaded Bots: ").append(DiSky.getManager().getBots().size()).append("\n");
                for (Bot bot : DiSky.getManager().getBots()) {
                    sb.append("  - ").append(bot.getName()).append(" login in as ").append(bot.getInstance().getSelfUser().getName()).append("#").append(bot.getInstance().getSelfUser().getDiscriminator()).append("\n");
                }
                sb.append("\n");
            });
            debugSections.put("modules", () -> {
                sb.append("== | Modules Information\n\n");
                sb.append("Loaded Modules: ").append(DiSky.getModuleManager().getModules().size()).append("\n");
                for (DiSkyModule module : DiSky.getModuleManager().getModules()) {
                    sb.append(" - ").append(module.getModuleInfo().name).append(" v").append(module.getModuleInfo().version).append("\n");
                }
                sb.append("\n");
            });
            debugSections.put("skript", () -> {
                sb.append("== | Skript Information\n\n");
                sb.append("Version: ").append(Skript.getVersion()).append("\n");
                sb.append("Loaded Addons: ").append(Skript.getAddons().size()).append("\n");
                for (SkriptAddon addon : Skript.getAddons()) {
                    sb.append("  - ").append(addon.getName()).append(" [").append(addon.getFile()).append("]\n");
                }
                sb.append("\n");
            });
            debugSections.put("listeners", () -> {
                sb.append("== | (DiSky) Listeners Information\n\n");
                sb.append("Loaded Listeners: ").append(CoreEventListener.AllRegisteredListeners.size()).append("\n");
                for (EventListener<?> listener : CoreEventListener.AllRegisteredListeners) {
                    sb.append("  - ").append(listener.getAttachedNode()).append(" / ").append(listener.isEnabled() ? "Enabled" : "Disabled").append("\n");
                    sb.append("    - Specific Bot Name: ").append(listener.getSpecificBotName()).append("\n");
                    sb.append("    - Waiting Log Event: ").append(listener.isWaitingLogEvent()).append(" [LogType: ").append((Object)listener.getLogType()).append("]").append("\n");
                    sb.append("    - Enabled: ").append(listener.enabled).append("\n");
                }
            });
            for (String section2 : desiredSections = args.length > 1 ? args[1].split(",") : (String[])debugSections.keySet().toArray(String[]::new)) {
                if (debugSections.containsKey(section2)) {
                    ((Runnable)debugSections.get(section2)).run();
                    continue;
                }
                String string = Utils.getClosest(section2, debugSections.keySet());
                sender.sendMessage(Utils.colored("&cUnknown debug section: &b" + section2 + " &7(Did you mean &b" + string + "&7?)"));
            }
            sb.append("\n---- End of the Debug File ----");
            try {
                File output = new File(DiSky.getInstance().getDataFolder(), "debug.txt");
                if (output.exists()) {
                    output.delete();
                }
                Files.write(output.toPath(), sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                sender.sendMessage(Utils.colored("&b------ &aSuccess! Exported to &2" + output.getAbsolutePath() + " &b------"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("modules")) {
            sender.sendMessage(Utils.colored("&b------ &9DiSky v" + DiSky.getInstance().getDescription().getVersion() + " Modules (" + DiSky.getModuleManager().getModules().size() + ") &b------"));
            sender.sendMessage(Utils.colored(""));
            for (DiSkyModule module : DiSky.getModuleManager().getModules()) {
                sender.sendMessage(Utils.colored(" &7- &b" + module.getModuleInfo().name + " &3made by &b" + module.getModuleInfo().author + " &3version &b" + String.valueOf(module.getModuleInfo().version)));
            }
            sender.sendMessage(Utils.colored(""));
            return true;
        }
        if (args[0].equalsIgnoreCase("bots")) {
            sender.sendMessage(Utils.colored("&b------ &9DiSky v" + DiSky.getInstance().getDescription().getVersion() + " Bots (" + DiSky.getManager().getBots().size() + ") &b------"));
            sender.sendMessage(Utils.colored(""));
            for (Bot bot : DiSky.getManager().getBots()) {
                sender.sendMessage(Utils.colored("  &7- &b" + bot.getName() + " &3loaded as &b" + bot.getDiscordName() + "&3, ping:&b " + bot.getInstance().getGatewayPing() + "ms"));
            }
            sender.sendMessage(Utils.colored(""));
            return true;
        }
        if (args[0].equalsIgnoreCase("bot")) {
            Bot bot;
            String botName = args.length > 1 ? args[1] : null;
            Bot bot2 = bot = botName == null ? null : DiSky.getManager().getBotByName(botName);
            if (botName == null || bot == null) {
                sender.sendMessage(Utils.colored("&cYou must specify a valid bot name!"));
                return false;
            }
            sender.sendMessage(Utils.colored("&b------ &9DiSky v" + DiSky.getInstance().getDescription().getVersion() + " Bot &b------"));
            sender.sendMessage(Utils.colored(""));
            sender.sendMessage(Utils.colored("  &7- &3Name: &b" + bot.getName()));
            sender.sendMessage(Utils.colored("  &7- &3Discord Name: &b" + bot.getDiscordName()));
            sender.sendMessage(Utils.colored("  &7- &3Uptime: &b" + String.valueOf(bot.getUptime())));
            sender.sendMessage(Utils.colored("  &7- &3Ping: &b" + bot.getInstance().getGatewayPing() + "ms"));
            sender.sendMessage(Utils.colored("  &7- &3Gateway Intents (" + bot.getInstance().getGatewayIntents().size() + "):"));
            for (GatewayIntent intent : bot.getInstance().getGatewayIntents()) {
                sender.sendMessage(Utils.colored("    &7- &b" + intent.name().toLowerCase().replace("_", " ")));
            }
            sender.sendMessage(Utils.colored(""));
            return true;
        }
        if (args[0].equalsIgnoreCase("reloadconfig")) {
            sender.sendMessage(Utils.colored("&b------ &9DiSky v" + DiSky.getInstance().getDescription().getVersion() + " Configuration Reloading &b------"));
            boolean wasDebug = ConfigManager.get("debug", false);
            long before = System.currentTimeMillis();
            ConfigManager.reloadConfig(DiSky.getInstance());
            sender.sendMessage(Utils.colored("&b------ &aSuccess! Took &2" + (System.currentTimeMillis() - before) + "ms! &b------"));
            if (wasDebug != ConfigManager.get("debug", false) && ConfigManager.get("debug", false).booleanValue()) {
                sender.sendMessage(Utils.colored("&5--------> &dDebug mode has been enabled!"));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("eventdocs")) {
            sender.sendMessage(Utils.colored("&b------ &9DiSky v" + DiSky.getInstance().getDescription().getVersion() + " Events Documentation &b------"));
            long before = System.currentTimeMillis();
            File file = new File(DiSky.getInstance().getDataFolder(), "events-docs.txt");
            if (file.exists()) {
                file.delete();
            }
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("---\nicon: material/check-all\n---\n\n# Events\n\n[[[% import 'macros.html' as macros %]]]\n\n## Information: Retrieve-Values\n\nFor some event, you can see a `retrieve values` section. Some values are given by Discord directly, and others needs another **request** to Discord to get the value (those are in as `retrieve values`).\n\n!!! example \"\"\n    For instance in the [Reaction Add Event](#reaction-add), Discord gives us the message ID only, so you can use its retrieve value to get the actual message:\n\n    ```applescript\n    on reaction add:\n        # </>\n\n        retrieve event value \"message\" and store it in {_message}\n        # now you can use {_message} as the message that was reacted to!\n    ```\n\n");
                Map<EventCategory, List<EventBuilder>> groupedEvents = EventBuilder.REGISTERED_EVENTS.stream().filter(e -> e.getCategory() != null).collect(Collectors.groupingBy(EventBuilder::getCategory));
                List<EventBuilder> uncategorizedEvents = EventBuilder.REGISTERED_EVENTS.stream().filter(e -> e.getCategory() == null).toList();
                for (EventBuilder eventBuilder : uncategorizedEvents) {
                    String doc = eventBuilder.createDocumentation();
                    if (doc == null) continue;
                    builder.append(doc);
                }
                for (Map.Entry entry : groupedEvents.entrySet()) {
                    builder.append("## ").append(((EventCategory)entry.getKey()).name()).append("\n\n");
                    builder.append(String.join((CharSequence)"\n", ((EventCategory)entry.getKey()).description())).append("\n\n");
                    for (EventBuilder eventBuilder : (List)entry.getValue()) {
                        String doc = eventBuilder.createDocumentation();
                        if (doc == null) continue;
                        builder.append(doc);
                    }
                }
                Files.writeString(file.toPath(), (CharSequence)builder.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                sender.sendMessage(Utils.colored("&cAn error occurred while generating the events documentation!"));
                return false;
            }
            sender.sendMessage(Utils.colored("&b------ &aSuccess! Took &2" + (System.currentTimeMillis() - before) + "ms! &b------"));
            return true;
        }
        return this.onCommand(sender, command, label, new String[0]);
    }
}

