/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.actionrow.ActionRowChildComponent;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.dv8tion.jda.internal.utils.Helpers;
import net.itsthesky.disky.core.Utils;
import net.itsthesky.disky.elements.components.core.ComponentRow;

public final class JDAUtils {
    public static MessageCreateBuilder constructCreateMessage(Object input) {
        if (input == null) {
            return null;
        }
        MessageCreateBuilder builder = new MessageCreateBuilder();
        if (input instanceof MessageCreateBuilder) {
            return (MessageCreateBuilder)input;
        }
        if (input instanceof String) {
            builder.addContent((String)input);
        }
        if (input instanceof EmbedBuilder) {
            builder.setEmbeds(((EmbedBuilder)input).build());
        }
        return builder;
    }

    public static MessageEditBuilder constructEditMessage(Object input) {
        if (input == null) {
            return null;
        }
        MessageEditBuilder builder = new MessageEditBuilder();
        if (input instanceof MessageEditBuilder) {
            return (MessageEditBuilder)input;
        }
        if (input instanceof String) {
            builder.setContent((String)input);
        }
        if (input instanceof EmbedBuilder) {
            builder.setEmbeds(((EmbedBuilder)input).build());
        }
        return builder;
    }

    public static Icon parseIcon(String value) {
        InputStream iconStream;
        if (Utils.isURL(value)) {
            try {
                iconStream = new URL(value).openStream();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                return null;
            }
        }
        File iconFile = new File(value);
        if (iconFile == null || !iconFile.exists()) {
            return null;
        }
        try {
            iconStream = new FileInputStream(iconFile);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        try {
            return Icon.from(iconStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FileUpload parseFile(String source2) {
        InputStream fileStream;
        if (source2 == null || source2.isEmpty()) {
            return null;
        }
        if (Utils.isURL(source2)) {
            try {
                fileStream = new URL(source2).openStream();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                return null;
            }
        } else {
            File file = new File(source2);
            if (file == null || !file.exists()) {
                return null;
            }
            try {
                FileInputStream fileStream2 = new FileInputStream(file);
                return FileUpload.fromData(fileStream2, file.getName());
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return FileUpload.fromData(fileStream, "file");
    }

    public static Component[] convert(ComponentRow[] rows) {
        ArrayList<ActionRowChildComponent> components = new ArrayList<ActionRowChildComponent>();
        for (ComponentRow row2 : rows) {
            components.addAll(row2.asComponents());
        }
        return components.toArray(new Component[0]);
    }

    public static Class<?> getOptionClass(OptionType type) {
        return switch (type) {
            case OptionType.ROLE -> Role.class;
            case OptionType.USER -> User.class;
            case OptionType.CHANNEL -> MessageChannel.class;
            case OptionType.NUMBER -> Number.class;
            case OptionType.INTEGER -> Integer.class;
            case OptionType.STRING -> String.class;
            case OptionType.ATTACHMENT -> Message.Attachment.class;
            case OptionType.BOOLEAN -> Boolean.class;
            case OptionType.MENTIONABLE -> IMentionable.class;
            default -> Object.class;
        };
    }

    public static Object parseOptionValue(OptionMapping option) {
        try {
            switch (option.getType()) {
                case ROLE: {
                    return option.getAsRole();
                }
                case USER: {
                    return option.getAsUser();
                }
                case CHANNEL: {
                    return option.getAsChannel().asGuildMessageChannel();
                }
                case NUMBER: {
                    return option.getAsDouble();
                }
                case INTEGER: {
                    return option.getAsInt();
                }
                case STRING: {
                    return option.getAsString();
                }
                case ATTACHMENT: {
                    return option.getAsAttachment();
                }
                case BOOLEAN: {
                    return option.getAsBoolean();
                }
                case MENTIONABLE: {
                    return option.getAsMentionable();
                }
            }
            return null;
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    public static boolean isSnowflake(String snowflake) {
        return snowflake.length() <= 20 && Helpers.isNumeric(snowflake);
    }

    public static String getFileNameFromUrl(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        int lastSlashIndex = url.lastIndexOf(47);
        if (lastSlashIndex == -1 || lastSlashIndex == url.length() - 1) {
            return null;
        }
        String fileName = url.substring(lastSlashIndex + 1);
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf(63));
        }
        if (fileName.isEmpty()) {
            return null;
        }
        if (fileName.length() > 255) {
            fileName = fileName.substring(0, 255);
        }
        return fileName;
    }
}

