/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import ch.njol.skript.util.Version;
import com.google.gson.Gson;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.itsthesky.disky.DiSky;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateCheckerTask
extends BukkitRunnable {
    public static VersionState STATE = VersionState.UNKNOWN;
    private static final String VERSIONS_URL = "https://api.modrinth.com/v2/project/disky/version";
    private static final Gson GSON = new Gson();
    private DiSky plugin;

    public UpdateCheckerTask(DiSky plugin) {
        this.plugin = plugin;
    }

    public void run() {
        try {
            this.plugin.getLogger().info("Checking for updates...");
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(VERSIONS_URL)).GET().build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                this.plugin.getLogger().warning("Failed to check for updates: " + response.statusCode());
                return;
            }
            String body = response.body();
            ModrinthVersion[] versions = GSON.fromJson(body, ModrinthVersion[].class);
            if (versions.length == 0) {
                this.plugin.getLogger().warning("No versions found.");
                return;
            }
            ModrinthVersion latestVersion = versions[0];
            Version latestVersionNumber = new Version(latestVersion.version_number);
            Version currentVersion = DiSky.getVersion();
            if (currentVersion.equals((Object)latestVersionNumber) || currentVersion.isLargerThan(latestVersionNumber)) {
                this.plugin.getLogger().info("You are using the latest version of DiSky: " + String.valueOf(currentVersion));
                STATE = VersionState.LATEST;
            } else {
                this.plugin.getLogger().warning("A new version of DiSky is available: " + String.valueOf(latestVersionNumber));
                this.plugin.getLogger().warning("You are using: " + String.valueOf(currentVersion));
                this.plugin.getLogger().warning("Download latest here: https://modrinth.com/plugin/disky/versions/" + latestVersion.id);
                STATE = VersionState.OUTDATED;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
            for (StackTraceElement element : e.getStackTrace()) {
                this.plugin.getLogger().warning("  at " + String.valueOf(element));
            }
        }
    }

    private static class ModrinthVersion {
        String id;
        String version_number;

        private ModrinthVersion() {
        }
    }

    public static enum VersionState {
        OUTDATED,
        LATEST,
        UNKNOWN;

    }
}

