/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.core;

import ch.njol.util.NonNullPair;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

public final class Utils {
    public static String colored(String input) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    public static String formatBytes(long input) {
        if (input < 1024L) {
            return input + " B";
        }
        if (input < 0x100000L) {
            return input / 1024L + " KB";
        }
        if (input < 0x40000000L) {
            return input / 1024L / 1024L + " MB";
        }
        return input / 1024L / 1024L / 1024L + " GB";
    }

    public static byte[] readBytesFromStream(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((len = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, len);
        }
        return buffer.toByteArray();
    }

    public static boolean equalsAnyIgnoreCase(String toMatch, String ... potentialMatches) {
        return Arrays.asList(potentialMatches).contains(toMatch);
    }

    public static <T> void catchAction(RestAction<T> action, Consumer<T> success, Consumer<Throwable> error) {
        try {
            action.queue(success, error);
        }
        catch (Throwable ex) {
            error.accept(ex);
        }
    }

    public static <T> void catchAction(RestAction<T> action, Event event) {
        Utils.catchAction(action, v -> {}, ex -> DiSkyRuntimeHandler.error((Exception)ex));
    }

    public static boolean isURL(String url) {
        try {
            URL url1 = new URL(url);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String repeat(String str, int amount) {
        return new String(new char[amount]).replace("\u0000", str);
    }

    public static <T extends Enum<T>> List<T> parseEnum(Class<T> clazz, List<String> raws) {
        ArrayList<T> values = new ArrayList<T>();
        for (String raw : raws) {
            try {
                values.add(Enum.valueOf(clazz, raw.toUpperCase(Locale.ROOT).replace(" ", "_")));
            }
            catch (Exception exception) {}
        }
        return values;
    }

    public static boolean isBetween(Number value, Number min, Number max) {
        return value.doubleValue() >= min.doubleValue() && value.doubleValue() <= max.doubleValue();
    }

    public static InputStream convert(BufferedImage image) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static List<NonNullPair<InputStream, String>> parseFiles(Object[] raws) throws FileNotFoundException {
        ArrayList<NonNullPair<InputStream, String>> streams = new ArrayList<NonNullPair<InputStream, String>>();
        int imageCount = 1;
        for (Object raw : raws) {
            if (raw instanceof BufferedImage) {
                streams.add((NonNullPair<InputStream, String>)new NonNullPair((Object)Utils.convert((BufferedImage)raw), (Object)("image-" + imageCount++ + ".png")));
            }
            if (!(raw instanceof String)) continue;
            streams.add((NonNullPair<InputStream, String>)new NonNullPair((Object)new FileInputStream((String)raw), (Object)new File((String)raw).getName()));
        }
        return streams;
    }

    public static EmbedBuilder convertJSONToEmbed(String json) {
        return EmbedBuilder.fromData(DataObject.fromJson(json));
    }

    public static String convertEmbedToJSON(EmbedBuilder builder) {
        if (builder.isEmpty()) {
            return "{}";
        }
        MessageEmbed embed2 = builder.build();
        return new String(embed2.toData().toJson(), StandardCharsets.UTF_8);
    }

    public static String getClosest(String input, Set<String> others) {
        ArrayList list = Lists.newArrayList(others);
        return list.stream().min(Comparator.comparingInt(s -> Utils.LevenshteinDistance(input, s))).orElse(null);
    }

    public static int LevenshteinDistance(String s, String t) {
        int j;
        int m = s.length();
        int n = t.length();
        int[][] d = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (j = 1; j <= n; ++j) {
            for (int i = 1; i <= m; ++i) {
                d[i][j] = s.charAt(i - 1) == t.charAt(j - 1) ? d[i - 1][j - 1] : Math.min(d[i - 1][j] + 1, Math.min(d[i][j - 1] + 1, d[i - 1][j - 1] + 1));
            }
        }
        return d[m][n];
    }
}

