/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.audit.AuditLogEntry;
import net.dv8tion.jda.api.components.ModalTopLevelComponent;
import net.dv8tion.jda.api.components.attribute.ICustomId;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.buttons.ButtonStyle;
import net.dv8tion.jda.api.components.selections.SelectMenu;
import net.dv8tion.jda.api.components.selections.SelectOption;
import net.dv8tion.jda.api.components.textinput.TextInput;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.automod.AutoModExecution;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.dv8tion.jda.api.entities.channel.concrete.MediaChannel;
import net.dv8tion.jda.api.entities.channel.concrete.NewsChannel;
import net.dv8tion.jda.api.entities.channel.concrete.PrivateChannel;
import net.dv8tion.jda.api.entities.channel.concrete.StageChannel;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.forums.BaseForumTag;
import net.dv8tion.jda.api.entities.channel.forums.ForumTag;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.messages.MessagePoll;
import net.dv8tion.jda.api.entities.sticker.GuildSticker;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.dv8tion.jda.api.modals.Modal;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.RoleAction;
import net.dv8tion.jda.api.requests.restaction.pagination.PinnedMessagePaginationAction;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.AbstractMessageBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessagePollBuilder;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.DiSkyType;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.commands.CommandEvent;
import net.itsthesky.disky.elements.commands.CommandObject;
import net.itsthesky.disky.elements.components.core.ComponentRow;
import net.itsthesky.disky.elements.componentsv2.base.ContainerBuilder;
import net.itsthesky.disky.elements.componentsv2.base.INewComponentBuilder;
import net.itsthesky.disky.elements.componentsv2.base.SectionBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.ButtonBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.FileDisplayBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.SeparatorBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.TextDisplayBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.ThumbnailBuilder;
import net.itsthesky.disky.elements.properties.polls.PollAnswerData;
import net.itsthesky.disky.elements.sections.automod.FilterType;
import net.itsthesky.disky.managers.ConfigManager;
import net.itsthesky.disky.managers.wrappers.AutoModRuleBuilder;
import org.skriptlang.skript.lang.comparator.Comparators;
import org.skriptlang.skript.lang.comparator.Relation;
import org.skriptlang.skript.lang.converter.Converters;

public class Types {
    static {
        new DiSkyType<Channel>(Channel.class, "channel", Channel::getName, null).eventExpression().register();
        new DiSkyType<ComponentInteraction>(ComponentInteraction.class, "interaction", null, null).eventExpression().register();
        new DiSkyType<GuildChannel>(GuildChannel.class, "guildchannel", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getGuildChannelById((String)input))).eventExpression().register();
        new DiSkyType<TextChannel>(TextChannel.class, "textchannel", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getTextChannelById((String)input))).eventExpression().register();
        new DiSkyType<VoiceChannel>(VoiceChannel.class, "voicechannel", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getVoiceChannelById((String)input))).eventExpression().register();
        new DiSkyType<AudioChannel>(AudioChannel.class, "audiochannel", Channel::getName, null).eventExpression().register();
        new DiSkyType<ThreadChannel>(ThreadChannel.class, "threadchannel", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getThreadChannelById((String)input))).eventExpression().register();
        new DiSkyType<Category>(Category.class, "category", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getCategoryById((String)input))).eventExpression().register();
        new DiSkyType<NewsChannel>(NewsChannel.class, "newschannel", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getNewsChannelById((String)input))).eventExpression().register();
        new DiSkyType<StageChannel>(StageChannel.class, "stagechannel", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getStageChannelById((String)input))).eventExpression().register();
        new DiSkyType<PrivateChannel>(PrivateChannel.class, "privatechannel", PrivateChannel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getPrivateChannelById((String)input))).eventExpression().register();
        new DiSkyType<ForumChannel>(ForumChannel.class, "forumchannel", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getForumChannelById((String)input))).eventExpression().register();
        new DiSkyType<MediaChannel>(MediaChannel.class, "mediachannel", Channel::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getMediaChannelById((String)input))).eventExpression().register();
        new DiSkyType<ChannelAction>(ChannelAction.class, "channelaction", action -> action.getType().name(), null).eventExpression().register();
        new DiSkyType<MessageChannel>(MessageChannel.class, "messagechannel", Channel::getName, null).eventExpression().register();
        new DiSkyType<RoleAction>(RoleAction.class, "roleaction", action -> "role action", null).eventExpression().register();
        new DiSkyType<ChannelType>(ChannelType.class, "channeltype", type -> type.name().toLowerCase().replace("_", " "), input -> {
            if (input.equalsIgnoreCase("text")) {
                return null;
            }
            if (input.equalsIgnoreCase("chat")) {
                return ChannelType.TEXT;
            }
            if (input.equalsIgnoreCase("thread")) {
                return ChannelType.GUILD_PUBLIC_THREAD;
            }
            if (input.equalsIgnoreCase("public thread")) {
                return ChannelType.GUILD_PUBLIC_THREAD;
            }
            if (input.equalsIgnoreCase("private thread")) {
                return ChannelType.GUILD_PRIVATE_THREAD;
            }
            if (input.equalsIgnoreCase("news thread")) {
                return ChannelType.GUILD_NEWS_THREAD;
            }
            return ChannelType.valueOf(input.toUpperCase());
        }, true).eventExpression().register();
        new DiSkyType<AutoModExecution>(AutoModExecution.class, "automod", Object::toString, null).eventExpression().register();
        new DiSkyType<ComponentRow>(ComponentRow.class, "row", row2 -> row2.asComponents().stream().map(Object::toString).toList().toString(), null).eventExpression().register();
        new DiSkyType<Modal.Builder>(Modal.Builder.class, "modal", Modal.Builder::getId, null).eventExpression().register();
        new DiSkyType<ModalTopLevelComponent>(ModalTopLevelComponent.class, "modalcomponent", comp -> Integer.toString(comp.getUniqueId()), null).eventExpression().register();
        new DiSkyType<Button>(Button.class, "button", ICustomId::getId, null).eventExpression().register();
        new DiSkyType<SelectMenu.Builder>(SelectMenu.Builder.class, "dropdown", SelectMenu.Builder::getId, null).eventExpression().register();
        new DiSkyType<SelectOption>(SelectOption.class, "selectoption", option -> option.toData().toString(), null).eventExpression().register();
        new DiSkyType<TextInput.Builder>(TextInput.Builder.class, "textinput", TextInput.Builder::getId, null).eventExpression().register();
        DiSkyType.fromEnum(ButtonStyle.class, "buttonstyle", "buttonstyle").register();
        new DiSkyType<INewComponentBuilder>(INewComponentBuilder.class, "newcomponent", c -> "new component builder", null).eventExpression().register();
        new DiSkyType<ContainerBuilder>(ContainerBuilder.class, "container", c -> "container builder", null).eventExpression().register();
        new DiSkyType<SectionBuilder>(SectionBuilder.class, "containersection", c -> "section builder", null).eventExpression().register();
        new DiSkyType<FileDisplayBuilder>(FileDisplayBuilder.class, "filedisplaycomponent", FileDisplayBuilder::toString, null).eventExpression().register();
        new DiSkyType<TextDisplayBuilder>(TextDisplayBuilder.class, "textdisplaycomponent", TextDisplayBuilder::toString, null).eventExpression().register();
        new DiSkyType<SeparatorBuilder>(SeparatorBuilder.class, "separatorcomponent", SeparatorBuilder::toString, null).eventExpression().register();
        new DiSkyType<ThumbnailBuilder>(ThumbnailBuilder.class, "thumbnailcomponent", ThumbnailBuilder::toString, null).eventExpression().register();
        new DiSkyType<SlashCommandData>(SlashCommandData.class, "slashcommand", slash -> slash.toData().toString(), null).eventExpression().register();
        new DiSkyType<SubcommandGroupData>(SubcommandGroupData.class, "slashcommandgroup", slash -> slash.toData().toString(), null).eventExpression().register();
        new DiSkyType<SubcommandData>(SubcommandData.class, "subslashcommand", slash -> slash.toData().toString(), null).eventExpression().register();
        new DiSkyType<OptionData>(OptionData.class, "slashoption", slash -> slash.toData().toString(), null).eventExpression().register();
        new DiSkyType<Command.Choice>(Command.Choice.class, "slashchoice", Command.Choice::getName, null).eventExpression().register();
        String suffix = ConfigManager.get("suffix-option-types", false) != false ? " option" : null;
        DiSkyType.fromEnum(OptionType.class, "optiontype", "optiontype", suffix).register();
        new DiSkyType<Role>(Role.class, "role", Role::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getRoleById((String)input))).eventExpression().register();
        new DiSkyType<ForumTag>(ForumTag.class, "forumtag", BaseForumTag::getName, null).eventExpression().register();
        new DiSkyType<ScheduledEvent>(ScheduledEvent.class, "scheduledevent", ScheduledEvent::getName, null).eventExpression().register();
        new DiSkyType<Webhook>(Webhook.class, "webhook", Webhook::getName, null).eventExpression().register();
        new DiSkyType<Message>(Message.class, "message", Message::getContentRaw, id -> CommandEvent.lastEvent == null ? null : CommandEvent.lastEvent.getMessageChannel().getHistory().getMessageById((String)id)).eventExpression().register();
        new DiSkyType<Message.Attachment>(Message.Attachment.class, "attachment", Message.Attachment::getUrl, null).eventExpression().register();
        new DiSkyType<MessageCreateBuilder>(MessageCreateBuilder.class, "messagecreatebuilder", AbstractMessageBuilder::getContent, null).eventExpression().register();
        new DiSkyType<Emote>(Emote.class, "emote", Emote::getAsMention, null).eventExpression().register();
        new DiSkyType<MessageReaction>(MessageReaction.class, "reaction", messageReaction -> Emote.fromUnion(messageReaction.getEmoji()).getAsMention(), null).eventExpression().register();
        new DiSkyType<Sticker>(Sticker.class, "sticker", Sticker::getName, null).eventExpression().register();
        new DiSkyType<GuildSticker>(GuildSticker.class, "guildsticker", Sticker::getName, null).eventExpression().register();
        new DiSkyType<EmbedBuilder>(EmbedBuilder.class, "embedbuilder", embedBuilder -> embedBuilder.getDescriptionBuilder().toString(), null).eventExpression().register();
        new DiSkyType<MessageEmbed.Field>(MessageEmbed.Field.class, "embedfield", MessageEmbed.Field::getValue, null).eventExpression().register();
        new DiSkyType<MessagePollBuilder>(MessagePollBuilder.class, "messagepollbuilder", v -> "a discord poll", null).eventExpression().register();
        new DiSkyType<PollAnswerData>(PollAnswerData.class, "pollanswer", PollAnswerData::asString, null).eventExpression().register();
        new DiSkyType<MessagePoll>(MessagePoll.class, "messagepoll", v -> v.getQuestion().getText(), null).eventExpression().register();
        new DiSkyType<FileUpload>(FileUpload.class, "fileupload", "fileuploads?", FileUpload::getName, null, false).eventExpression().register();
        new DiSkyType<PinnedMessagePaginationAction.PinnedMessage>(PinnedMessagePaginationAction.PinnedMessage.class, "pinnedmessage", msg -> msg.getMessage().getContentRaw(), null).eventExpression().register();
        if (!ConfigManager.get("fix-skript-online-status", false).booleanValue()) {
            DiSkyType.fromEnum(OnlineStatus.class, "onlinestatus", "onlinestatus").register();
        }
        DiSkyType.fromEnum(Permission.class, "permission", "permission").register();
        new DiSkyType<User>(User.class, "user", user -> user.getEffectiveName(), input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getUserById((String)input))).eventExpression().register();
        new DiSkyType<User.Profile>(User.Profile.class, "userprofile", User.Profile::toString, null).eventExpression().register();
        new DiSkyType<Activity>(Activity.class, "activity", Activity::getName, null).eventExpression().register();
        new DiSkyType<Guild.Ban>(Guild.Ban.class, "ban", Guild.Ban::getReason, null).eventExpression().register();
        new DiSkyType<Invite>(Invite.class, "invite", Invite::getUrl, null).eventExpression().register();
        new DiSkyType<AuditLogEntry>(AuditLogEntry.class, "logentry", ISnowflake::getId, null).eventExpression().register();
        new DiSkyType<CommandObject>(CommandObject.class, "discordcommand", CommandObject::getName, null).eventExpression().register();
        new DiSkyType<Guild>(Guild.class, "guild", Guild::getName, input -> DiSky.getManager().searchIfAnyPresent(bot -> bot.getInstance().getGuildById((String)input))).eventExpression().register();
        new DiSkyType<Member>(Member.class, "member", member -> member.getUser().getEffectiveName(), id -> {
            CommandEvent event = CommandEvent.lastEvent;
            if (event == null) {
                return null;
            }
            if (event.getJDAEvent().isFromGuild()) {
                return CommandEvent.lastEvent.getGuild().getMemberById((String)id);
            }
            return null;
        }).eventExpression().register();
        new DiSkyType<Bot>(Bot.class, "bot", member -> member.getInstance().getSelfUser().getEffectiveName(), input -> DiSky.getManager().fromName((String)input)).eventExpression().register();
        new DiSkyType<ApplicationInfo>(ApplicationInfo.class, "applicationinfo", ApplicationInfo::getName, null).eventExpression().register();
        DiSkyType.fromEnum(Member.MemberFlag.class, "memberflag", "memberflag").eventExpression().register();
        new DiSkyType<AutoModRuleBuilder>(AutoModRuleBuilder.class, "automodrule", AutoModRuleBuilder::toString, null).eventExpression().register();
        DiSkyType.fromEnum(FilterType.class, "filtertype", "filtertype").eventExpression().register();
    }

    public static class DiSkyConverters {
        static {
            Class[] channelClasses;
            Converters.registerConverter(Member.class, Role[].class, member -> member.getRoles().toArray(new Role[0]));
            Converters.registerConverter(Member.class, User.class, Member::getUser);
            Converters.registerConverter(Bot.class, User.class, bot -> bot.getInstance().getSelfUser());
            Converters.registerConverter(Message.class, String.class, Message::getContentRaw);
            Converters.registerConverter(Emote.class, String.class, Emote::toString);
            Converters.registerConverter(IMentionable.class, String.class, IMentionable::getAsMention);
            Converters.registerConverter(ISnowflake.class, String.class, ISnowflake::getId);
            Converters.registerConverter(Button.class, ComponentRow.class, btn -> new ComponentRow(null, null, Collections.singletonList(btn)));
            Converters.registerConverter(SelectMenu.Builder.class, ComponentRow.class, menu -> new ComponentRow((SelectMenu)menu.build(), null, (List<Button>)new ArrayList<Button>()));
            Converters.registerConverter(Button.class, ButtonBuilder.class, btn -> (ButtonBuilder)INewComponentBuilder.of(btn));
            Converters.registerConverter(PinnedMessagePaginationAction.PinnedMessage.class, Message.class, PinnedMessagePaginationAction.PinnedMessage::getMessage);
            Comparators.registerComparator(Channel.class, ChannelType.class, (channel, type) -> Relation.get((int)channel.getType().compareTo(type)));
            for (Class channelClass : channelClasses = new Class[]{MessageChannel.class, GuildChannel.class, AudioChannel.class, ThreadChannel.class, Category.class, NewsChannel.class, StageChannel.class, PrivateChannel.class, ForumChannel.class, MediaChannel.class, TextChannel.class, VoiceChannel.class}) {
                Converters.registerConverter(Channel.class, (Class)channelClass, original -> {
                    if (channelClass.isInstance(original)) {
                        return channelClass.cast(original);
                    }
                    return null;
                });
            }
        }
    }
}

