/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.commands;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.commands.CommandEvent;
import net.itsthesky.disky.elements.commands.CommandFactory;
import net.itsthesky.disky.elements.commands.CommandObject;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.lang.entry.EntryContainer;

public class CommandRegistry
extends SelfRegisteringSkriptEvent {
    private static final Pattern MATCHER_PATTERN = Pattern.compile("discord command (\\S+)( .+)?$");
    public static final SectionValidator commandStructure = new SectionValidator().addEntry("usage", true).addEntry("description", true).addEntry("roles", true).addEntry("aliases", true).addEntry("prefixes", true).addEntry("category", true).addEntry("bots", true).addEntry("executable in", true).addEntry("permissions", true).addEntry("permission message", true).addSection("trigger", false);
    private String arguments;
    private String command;

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, @NotNull SkriptParser.ParseResult parser) {
        return true;
    }

    public boolean load() {
        EntryContainer entryContainer = this.getEntryContainer();
        String fullCommand = entryContainer.getSource().getKey();
        assert (fullCommand != null);
        Matcher matcher = MATCHER_PATTERN.matcher(fullCommand = ScriptLoader.replaceOptions((String)fullCommand));
        boolean matches = matcher.matches();
        if (!matches) {
            Skript.error((String)"Invalid command structure pattern");
            return false;
        }
        this.command = matcher.group(1);
        this.arguments = matcher.group(2);
        SectionNode sectionNode = (SectionNode)this.getParser().getNode();
        String originalName = this.getParser().getCurrentEventName();
        Class[] originalEvents = this.getParser().getCurrentEvents();
        Kleenean originalDelay = this.getParser().getHasDelayBefore();
        this.getParser().setCurrentEvent("discord command", new Class[]{CommandEvent.class});
        CommandObject cmd = CommandFactory.getInstance().add(sectionNode);
        this.command = cmd == null ? this.command : cmd.getName();
        this.getParser().setCurrentEvent(originalName, originalEvents);
        this.getParser().setHasDelayBefore(originalDelay);
        this.nukeSectionNode(sectionNode);
        return cmd != null;
    }

    public void register(@NotNull Trigger t) {
    }

    public void unregister(@NotNull Trigger t) {
        CommandFactory.getInstance().remove(this.command);
    }

    public void unregisterAll() {
        CommandFactory.getInstance().commandMap.clear();
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "discord command " + this.command + (this.arguments == null ? "" : this.arguments);
    }

    public void nukeSectionNode(SectionNode sectionNode) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : sectionNode) {
            nodes.add(node);
        }
        for (Node n : nodes) {
            sectionNode.remove(n);
        }
    }

    static {
        Skript.registerEvent((String)"Discord Command", CommandRegistry.class, CommandEvent.class, (String[])new String[]{"discord command <([^\\s]+)( .+)?$>"}).description(new String[]{"Custom DiSky discord command system. Arguments works like the normal skript's one and accept both optional and require arguments."}).examples(new String[]{"discord command move <member> <voicechannel>:\n    prefixes: !\n    trigger:\n        reply with mention tag of arg-2\n        move arg-1 to arg-2"}).since("3.0");
        SkriptUtils.registerValue(CommandEvent.class, CommandObject.class, CommandEvent::getCommand);
        SkriptUtils.registerValue(CommandEvent.class, Member.class, CommandEvent::getMember);
        SkriptUtils.registerValue(CommandEvent.class, Message.class, CommandEvent::getMessage);
        SkriptUtils.registerValue(CommandEvent.class, User.class, CommandEvent::getUser);
        SkriptUtils.registerValue(CommandEvent.class, Guild.class, CommandEvent::getGuild);
        SkriptUtils.registerValue(CommandEvent.class, MessageChannel.class, CommandEvent::getMessageChannel);
        SkriptUtils.registerValue(CommandEvent.class, GuildChannel.class, CommandEvent::getTxtChannel);
        SkriptUtils.registerValue(CommandEvent.class, String.class, CommandEvent::getPrefix);
        SkriptUtils.registerValue(CommandEvent.class, Bot.class, event -> DiSky.getManager().fromJDA(event.getBot()));
    }
}

