/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.selections.SelectMenu;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonInteraction;
import net.dv8tion.jda.api.interactions.components.selections.SelectMenuInteraction;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.api.events.specific.ComponentInteractionEvent;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditComponent
extends AsyncEffect {
    private Node node;
    private Expression<Object> exprComponent;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        if (!EasyElement.containsInterfaces(ComponentInteractionEvent.class)) {
            Skript.error((String)"The edit component effect can only be used in a component interaction event!");
            return false;
        }
        this.node = this.getParser().getNode();
        this.exprComponent = expressions[0];
        return true;
    }

    protected void execute(@NotNull Event event) {
        RestAction<Void> action;
        Object component = this.exprComponent.getSingle(event);
        if (component == null) {
            return;
        }
        ComponentInteractionEvent componentEvent = (ComponentInteractionEvent)event;
        if (componentEvent.getComponentInteraction().getComponentType().equals((Object)Component.Type.BUTTON)) {
            if (!(component instanceof Button)) {
                SkriptUtils.error(this.node, "You're trying to edit a button interaction, but the provided component is a dropdown!");
                return;
            }
            Button button = (Button)component;
            ButtonInteraction buttonInteraction = (ButtonInteraction)componentEvent.getComponentInteraction();
            action = buttonInteraction.editButton(button);
        } else if (componentEvent.getComponentInteraction().getComponentType().name().contains("SELECT")) {
            if (!(component instanceof SelectMenu.Builder)) {
                SkriptUtils.error(this.node, "You're trying to edit a dropdown interaction, but the provided component is a button!");
                return;
            }
            SelectMenu.Builder dropdown = (SelectMenu.Builder)component;
            SelectMenuInteraction dropdownInteraction = (SelectMenuInteraction)componentEvent.getComponentInteraction();
            action = dropdownInteraction.editSelectMenu((SelectMenu)dropdown.build());
        } else {
            SkriptUtils.error(this.node, "The component type of the interaction is not a button or dropdown!");
            return;
        }
        try {
            action.complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex, this.node);
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "edit the component " + this.exprComponent.toString(event, debug);
    }

    static {
        Skript.registerEffect(EditComponent.class, (String[])new String[]{"edit [component] (button|dropdown|select[( |-)]menu) [of [the] (interaction|event)] to [show] %button/dropdown%"});
    }
}

