/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import java.util.ArrayList;
import java.util.Arrays;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Group / Command Sub-Commands")
@Description(value={"Represent every sub-slash-command a slash-command or a group have.", "You can add sub-slash-commands to a group or a core slash-command, then add this group into the base slash command."})
public class ExprGroupCommands
extends MultiplyPropertyExpression<Object, SubcommandData> {
    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        Object group = EasyElement.parseSingle(this.getExpr(), e, null);
        SubcommandData[] datas = (SubcommandData[])delta;
        if (EasyElement.anyNull((Object)this, group, datas)) {
            return;
        }
        ArrayList<SubcommandData> news = new ArrayList<SubcommandData>(Arrays.asList(datas));
        ArrayList<SubcommandData> current = new ArrayList<SubcommandData>(Arrays.asList(this.convert((Object)group)));
        if (!current.isEmpty()) {
            current.clear();
        }
        switch (mode) {
            case ADD: {
                current.addAll(news);
                break;
            }
            case SET: {
                current.clear();
                current.addAll(news);
                break;
            }
            case RESET: 
            case REMOVE_ALL: {
                current.clear();
            }
        }
        try {
            if (group instanceof SubcommandGroupData) {
                ((SubcommandGroupData)group).addSubcommands(current);
            } else {
                ((SlashCommandData)group).addSubcommands(current);
            }
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
        }
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (EasyElement.isChangerMode(mode)) {
            return new Class[]{SubcommandData[].class, SubcommandData.class};
        }
        return new Class[0];
    }

    @Override
    @NotNull
    public Class<? extends SubcommandData> getReturnType() {
        return SubcommandData.class;
    }

    @Override
    protected String getPropertyName() {
        return "sub commands";
    }

    protected SubcommandData[] convert(Object data) {
        if (data instanceof SubcommandGroupData) {
            return ((SubcommandGroupData)data).getSubcommands().toArray(new SubcommandData[0]);
        }
        return ((SlashCommandData)data).getSubcommands().toArray(new SubcommandData[0]);
    }

    static {
        ExprGroupCommands.register(ExprGroupCommands.class, SubcommandData.class, "sub[( |-)]command[s]", "slashcommandgroup/slashcommand");
    }
}

