/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Locale;
import java.util.stream.Stream;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExprNewSlashCommand
extends SimpleExpression<Object> {
    private Expression<String> exprName;
    private Expression<String> exprDesc;
    private Type type;
    private boolean isNSFW;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        this.exprDesc = exprs[1];
        this.type = Type.fromPattern(matchedPattern);
        this.isNSFW = parseResult.expr.contains("nsfw");
        return true;
    }

    protected Object @NotNull [] get(@NotNull Event e) {
        String name = EasyElement.parseSingle(this.exprName, e, null);
        String desc = EasyElement.parseSingle(this.exprDesc, e, null);
        if (EasyElement.anyNull((Object)this, name, desc)) {
            return new Object[0];
        }
        if (this.type == Type.SUB_GROUP) {
            return new SubcommandGroupData[]{new SubcommandGroupData(name, desc)};
        }
        if (this.type == Type.SLASH_COMMAND) {
            return new SlashCommandData[]{Commands.slash(name, desc).setNSFW(this.isNSFW)};
        }
        return new SubcommandData[]{new SubcommandData(name, desc)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<?> getReturnType() {
        return this.type.getClazz();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "new " + this.type.toString() + " named " + this.exprName.toString(e, debug) + " with description " + this.exprDesc.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNewSlashCommand.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] [nsfw] slash[( |-)]command [with] [(the name|named)] %string% [and] with [the] desc[ription] %string%", "[a] [new] sub [slash][( |-)]command [with] [(the name|named)] %string% [and] with [the] desc[ription] %string%", "[a] [new] [slash][( |-)][command] group [with] [(the name|named)] %string% [and] with [the] desc[ription] %string%"});
    }

    static enum Type {
        SLASH_COMMAND(0, SlashCommandData.class),
        SUB_COMMAND(1, SubcommandData.class),
        SUB_GROUP(2, SubcommandGroupData.class);

        private final int pattern;
        private final Class<?> clazz;

        private Type(int pattern, Class<?> clazz) {
            this.pattern = pattern;
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public static Type fromPattern(int matchedPattern) {
            return Stream.of(Type.values()).filter(v -> v.pattern == matchedPattern).findAny().orElse(null);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT).replace("_", " ");
        }
    }
}

