/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="New User Command")
@Description(value={"Create a new user command, to be updated on discord later.", "This will create a context command of USER type.", "Once created, you can execute it by right-clicking on a user, then going in 'Applications' -> <your user command name>"})
@Examples(value={"new user command named \"Warn User\""})
public class ExprNewUserCommand
extends SimpleExpression<CommandData> {
    private Expression<String> exprName;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        return true;
    }

    protected CommandData @NotNull [] get(@NotNull Event e) {
        String name = EasyElement.parseSingle(this.exprName, e, null);
        if (EasyElement.anyNull((Object)this, name)) {
            return new CommandData[0];
        }
        return new CommandData[]{Commands.user(name)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends CommandData> getReturnType() {
        return CommandData.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "new user command named " + this.exprName.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNewUserCommand.class, CommandData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] user[( |-)]command [with] [(the name|named)] %string%"});
    }
}

