/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.commands;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.api.skript.SpecificBotEffect;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.Debug;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Unregister Command")
@Description(value={"Unregister a specific slash command from local or global context of a bot.", "You must provide the command's name. Keep in mind this **SHOULD NOT** be used!", "The best way remains to update bot's commands without the command you want to delete!"})
@Examples(value={"unregister command \"test\" locally in guild with id \"000\""})
public class UnregisterCommand
extends SpecificBotEffect {
    private Expression<String> exprNames;
    private boolean isGlobal;
    private Expression<Object> exprEntity;

    @Override
    public boolean initEffect(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.exprNames = expressions[0];
        this.exprEntity = expressions[1];
        this.isGlobal = (parseResult.mark & 1) != 0;
        return true;
    }

    @Override
    public void runEffect(@NotNull Event e, Bot bot) {
        String[] names = UnregisterCommand.parseList(this.exprNames, e, new String[0]);
        Object entity = UnregisterCommand.parseSingle(this.exprEntity, e, null);
        if (names.length == 0) {
            Debug.debug((Object)this, Debug.Type.EMPTY_LIST, "No names found.");
            this.restart();
            return;
        }
        if (UnregisterCommand.anyNull((Object)this, entity)) {
            this.restart();
            return;
        }
        @Nullable Guild guild = this.isGlobal ? null : (Guild)entity;
        RestAction<List<Command>> restAction = this.isGlobal ? bot.getInstance().retrieveCommands() : guild.retrieveCommands();
        restAction.queue(commands -> {
            List toDelete = commands.stream().filter(command -> Stream.of(names).anyMatch(name -> name.equalsIgnoreCase(command.getName()))).collect(Collectors.toList());
            RestAction action = RestAction.allOf(toDelete.stream().map(Command::delete).collect(Collectors.toList()));
            action.queue(x$0 -> this.restart(x$0), ex -> {
                this.restart();
                DiSkyRuntimeHandler.error((Exception)ex);
            });
        });
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "unregister commands " + this.exprNames.toString(e, debug) + " in " + (this.isGlobal ? "global" : "local") + " in " + this.exprEntity.toString(e, debug);
    }

    static {
        Skript.registerEffect(UnregisterCommand.class, (String[])new String[]{"unregister [the] [command[s]] %strings% [(1\u00a6globally|2\u00a6locally)] (in|from|of) [the] [(bot|guild)] %bot/guild%"});
    }
}

