/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.components.actionrow.ActionRowChildComponent;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.selections.SelectMenu;
import net.dv8tion.jda.api.components.textinput.TextInput;
import net.itsthesky.disky.elements.componentsv2.base.IContainerComponentBuilder;

public class ComponentRow
implements IContainerComponentBuilder<ActionRow> {
    private final List<Button> buttons = new ArrayList<Button>();
    private SelectMenu menu;
    private TextInput input;
    private int uniqueId = -1;

    public ComponentRow(SelectMenu menu, TextInput input, List<Button> buttons) {
        this.menu = menu;
        this.input = input;
        if (buttons != null) {
            this.buttons.addAll(buttons);
        }
    }

    public ComponentRow(List<Object> components) {
        this();
        for (Object component : components) {
            if (component instanceof SelectMenu) {
                SelectMenu menu = (SelectMenu)component;
                this.setMenu(menu);
                continue;
            }
            if (component instanceof Button) {
                Button button = (Button)component;
                this.add(button);
                continue;
            }
            if (component instanceof TextInput) {
                TextInput input = (TextInput)component;
                this.setInput(input);
                continue;
            }
            if (component instanceof SelectMenu.Builder) {
                SelectMenu.Builder menuBuilder = (SelectMenu.Builder)component;
                this.setMenu((SelectMenu)menuBuilder.build());
                continue;
            }
            if (!(component instanceof TextInput.Builder)) continue;
            TextInput.Builder inputBuilder = (TextInput.Builder)component;
            this.setInput(inputBuilder.build());
        }
    }

    public List<ActionRowChildComponent> asComponents() {
        if (this.getMenu() != null) {
            return Collections.singletonList(this.getMenu());
        }
        return new ArrayList<ActionRowChildComponent>(this.getButtons());
    }

    public void add(Button button) {
        this.buttons.add(button);
    }

    public ActionRow asActionRow() {
        return ActionRow.of(this.asComponents());
    }

    public void addAll(List<Component> components) {
        for (Component component : components) {
            if (component instanceof SelectMenu) {
                this.setMenu((SelectMenu)component);
                continue;
            }
            if (component instanceof Button) {
                this.add((Button)component);
                continue;
            }
            if (!(component instanceof TextInput)) continue;
            this.setInput((TextInput)component);
        }
    }

    public boolean isEmpty() {
        return this.menu == null && this.input == null && this.buttons.isEmpty();
    }

    @Override
    public void loadFrom(ActionRow component) {
        if (component == null) {
            this.menu = null;
            this.input = null;
            this.buttons.clear();
            return;
        }
        this.addAll(component.getActionComponents().stream().map(c -> c).toList());
    }

    @Override
    public ActionRow build() {
        return this.asActionRow();
    }

    public Button getSingleButton() {
        if (this.buttons.size() != 1) {
            throw new IllegalStateException("Cannot get single button from a row with " + this.buttons.size() + " buttons.");
        }
        return this.buttons.get(0);
    }

    @Generated
    public List<Button> getButtons() {
        return this.buttons;
    }

    @Generated
    public SelectMenu getMenu() {
        return this.menu;
    }

    @Generated
    public TextInput getInput() {
        return this.input;
    }

    @Override
    @Generated
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public void setMenu(SelectMenu menu) {
        this.menu = menu;
    }

    @Generated
    public void setInput(TextInput input) {
        this.input = input;
    }

    @Override
    @Generated
    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public ComponentRow() {
    }
}

