/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.create;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import net.dv8tion.jda.api.components.selections.EntitySelectMenu;
import net.dv8tion.jda.api.components.selections.SelectMenu;
import net.dv8tion.jda.api.components.selections.StringSelectMenu;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="New Dropdown")
@Description(value={"Create a new dropdown menu with different properties.", "There's two type of dropdown available:", "- String, only text values are accepted & pre-defined", "- Entity, only the specified entity type (role, channel and/or user) are accepted", "Therefore, you cannot add user, channel or role to a string dropdown and vice-versa.", "For entity dropdown, you can accept each type independently, or mix roles & users.", ":warning: YOU CANNOT MIX CHANNELS WITH ROLES OR USERS!"})
@Since(value={"4.6.0"})
@Examples(value={"new dropdown with id \"string\" # Default string dropdown", "new entity dropdown with id \"entities\" targeting \"user\" and \"role\" # Only user and role are accepted", "new entity dropdown with id \"channels\" targeting \"channel\" # Only channel are accepted"})
public class ExprNewDropdown
extends SimpleExpression<SelectMenu.Builder> {
    private Expression<String> exprId;
    private boolean isEntity;
    private boolean isDisabled;
    private Expression<String> exprTarget;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprId = exprs[0];
        boolean bl = this.isEntity = matchedPattern == 1;
        if (this.isEntity) {
            this.exprTarget = exprs[1];
        }
        this.isDisabled = parseResult.hasTag("disabled");
        return true;
    }

    protected SelectMenu.Builder @NotNull [] get(@NotNull Event e) {
        String id = EasyElement.parseSingle(this.exprId, e, null);
        if (EasyElement.anyNull((Object)this, id)) {
            return new SelectMenu.Builder[0];
        }
        if (this.isEntity) {
            String[] rawTargets = EasyElement.parseList(this.exprTarget, e, new String[0]);
            ArrayList<EntitySelectMenu.SelectTarget> targets = new ArrayList<EntitySelectMenu.SelectTarget>();
            for (String raw : rawTargets) {
                if (raw.equalsIgnoreCase("user") || raw.equalsIgnoreCase("users")) {
                    targets.add(EntitySelectMenu.SelectTarget.USER);
                    continue;
                }
                if (raw.equalsIgnoreCase("role") || raw.equalsIgnoreCase("roles")) {
                    targets.add(EntitySelectMenu.SelectTarget.ROLE);
                    continue;
                }
                if (raw.equalsIgnoreCase("channel") || raw.equalsIgnoreCase("channels")) {
                    targets.add(EntitySelectMenu.SelectTarget.CHANNEL);
                    continue;
                }
                Skript.warning((String)("Unknown target type '" + raw + "' for entity dropdown, skipping it."));
            }
            if (targets.isEmpty()) {
                Skript.error((String)"You must specify at least one target type for entity dropdown!");
                return new SelectMenu.Builder[0];
            }
            return new SelectMenu.Builder[]{EntitySelectMenu.create(id, targets).setDisabled(this.isDisabled)};
        }
        return new SelectMenu.Builder[]{StringSelectMenu.create(id).setDisabled(this.isDisabled)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends SelectMenu.Builder> getReturnType() {
        return SelectMenu.Builder.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "new dropdown with id " + this.exprId.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNewDropdown.class, SelectMenu.Builder.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] [string] [:disabled] drop[( |-)]down [with] [the] [id] %string%", "[a] [new] [:disabled] entit(y|ies) drop[( |-)]down [with] [the] [id] %string% targeting %strings%"});
    }
}

