/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.create;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.components.selections.SelectOption;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="New Dropdown Option")
@Description(value={"Create a new dropdown option with different properties.", "This is a predefined option holding a string value. It can only be used in string dropdowns.", "The value represent the returned string that this dropdown will return if this option is selected.", "The name / label is the actual shown name on the option.", "Description and emote are optional."})
@Examples(value={"set {_btn} to new enabled danger button with id \"button-id\" named \"Hello world :p\""})
public class ExprNewDropdownOption
extends SimpleExpression<SelectOption> {
    private Expression<String> exprValue;
    private Expression<String> exprName;
    private Expression<String> exprDesc;
    private Expression<Emote> exprEmote;
    private boolean isDefault;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprValue = exprs[0];
        this.exprName = exprs[1];
        this.exprDesc = exprs[2];
        this.exprEmote = exprs[3];
        this.isDefault = parseResult.expr.contains("new default");
        return true;
    }

    protected SelectOption @NotNull [] get(@NotNull Event e) {
        String value = EasyElement.parseSingle(this.exprValue, e, null);
        String name = EasyElement.parseSingle(this.exprName, e, null);
        @Nullable String desc = EasyElement.parseSingle(this.exprDesc, e, null);
        @Nullable Emote emote = EasyElement.parseSingle(this.exprEmote, e, null);
        if (EasyElement.anyNull((Object)this, value, name)) {
            return new SelectOption[0];
        }
        SelectOption option = SelectOption.of(name, value).withDefault(this.isDefault);
        if (desc != null) {
            option = option.withDescription(desc);
        }
        if (emote != null) {
            option = option.withEmoji(emote.getEmoji());
        }
        return new SelectOption[]{option};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends SelectOption> getReturnType() {
        return SelectOption.class;
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "new dropdown option with value " + this.exprValue.toString(e, debug) + " named " + this.exprName.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprNewDropdownOption.class, SelectOption.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] new [default] [dropdown] option with value %string% (named|with label) %-string% [with description [%-string%]] [with [emoji] %-emote%]"});
    }
}

