/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.properties;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.interactions.modals.ModalMapping;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.events.rework.ComponentEvents;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Modal Component Value / Values")
@Description(value={"Get the current value(s) of a sent component, currently only working in modals with text input & select menus.", "You have to precise what type of component you are trying to get, either 'textinput' or 'dropdown'."})
@Examples(value={"values of dropdown with id \"XXX\"", "value of textinput with id \"XXX\""})
public class ComponentValue
extends SimpleExpression<Object> {
    private Expression<String> exprId;
    private Class<?> returnType;
    private boolean isSingle;

    protected Object @NotNull [] get(@NotNull Event e) {
        String id = EasyElement.parseSingle(this.exprId, e, null);
        if (EasyElement.anyNull((Object)this, id)) {
            return new String[0];
        }
        ModalInteractionEvent event = ComponentEvents.MODAL_INTERACTION_EVENT.getJDAEvent(e);
        if (event == null) {
            return new String[0];
        }
        ModalMapping mapping = event.getValue(id);
        if (mapping == null) {
            return new String[0];
        }
        if (this.isSingle()) {
            return new String[]{mapping.getAsString()};
        }
        return mapping.getAsStringList().toArray(new String[0]);
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    @NotNull
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "value of component with id " + this.exprId.toString(e, debug);
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!EasyElement.containsEvent(ComponentEvents.MODAL_INTERACTION_EVENT.getBukkitEventClass())) {
            Skript.error((String)"You can only get values of components in a modal receive event.");
            return false;
        }
        this.returnType = parseResult.mark == 1 ? String.class : String[].class;
        this.isSingle = parseResult.mark == 1;
        this.exprId = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ComponentValue.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] [current] value[s] of [the] (1\u00a6text[( |-)]input|2\u00a6drop[( |-)]down) [with [the] id] %string%"});
    }
}

