/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.components.properties;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Map;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.localization.LocalizationMap;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Command Localization")
@Description(value={"Represents the localization of the name or the description of a slash/sub command.", "You can add **Locale Data** (check for expression) to them.", "Basically, the command's name & description will be according to the client's language code.", "Documentation: https://docs.disky.me/advanced-stuff/slash-commands#using-localizations-v4.3.0+"})
public class PropLocalization
extends MultiplyPropertyExpression<Object, LocaleData> {
    private boolean isName;

    @Override
    public boolean init(Expression<?> @NotNull [] expr, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.expr = expr[0];
        this.isName = parseResult.expr.startsWith("name");
        return true;
    }

    protected LocaleData[] convert(Object rawData) {
        if (rawData instanceof SlashCommandData) {
            return LocaleData.convert(this.isName ? ((SlashCommandData)rawData).getNameLocalizations() : ((SlashCommandData)rawData).getDescriptionLocalizations());
        }
        return LocaleData.convert(this.isName ? ((SubcommandData)rawData).getNameLocalizations() : ((SubcommandData)rawData).getDescriptionLocalizations());
    }

    public @Nullable Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (EasyElement.isChangerMode(mode)) {
            return new Class[]{LocaleData.class, LocaleData[].class};
        }
        return new Class[0];
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        LocaleData[] locales;
        if (!EasyElement.isValid(delta)) {
            return;
        }
        Object rawData = EasyElement.parseSingle(this.getExpr(), e, null);
        if (rawData == null) {
            return;
        }
        for (LocaleData locale : locales = (LocaleData[])delta) {
            if (locale == null) {
                return;
            }
            if (this.isName) {
                if (rawData instanceof SlashCommandData) {
                    ((SlashCommandData)rawData).setNameLocalization(locale.getLocale(), locale.getValue());
                    continue;
                }
                if (rawData instanceof SubcommandData) {
                    ((SubcommandData)rawData).setNameLocalization(locale.getLocale(), locale.getValue());
                    continue;
                }
                Skript.error((String)("Unknown type of data: " + rawData.getClass().getName()));
                continue;
            }
            if (rawData instanceof SlashCommandData) {
                ((SlashCommandData)rawData).setDescriptionLocalization(locale.getLocale(), locale.getValue());
                continue;
            }
            if (rawData instanceof SubcommandData) {
                ((SubcommandData)rawData).setDescriptionLocalization(locale.getLocale(), locale.getValue());
                continue;
            }
            Skript.error((String)("Unknown type of data: " + rawData.getClass().getName()));
        }
    }

    @Override
    @NotNull
    public Class<? extends LocaleData> getReturnType() {
        return LocaleData.class;
    }

    @Override
    protected String getPropertyName() {
        return "localization";
    }

    static {
        PropLocalization.register(PropLocalization.class, LocaleData.class, "(name|description)['s] (localization[s]|locale[s])", "slashcommand/subslashcommand");
    }

    public static final class LocaleData {
        private final DiscordLocale locale;
        private final String value;

        public LocaleData(DiscordLocale locale, String value) {
            this.locale = locale;
            this.value = value;
        }

        public static LocaleData[] convert(LocalizationMap localizationMap) {
            Map<DiscordLocale, String> map = localizationMap.toMap();
            LocaleData[] locales = new LocaleData[map.size()];
            int i = 0;
            for (DiscordLocale locale : map.keySet()) {
                locales[i++] = new LocaleData(locale, map.get((Object)locale));
            }
            return locales;
        }

        public DiscordLocale getLocale() {
            return this.locale;
        }

        public String getValue() {
            return this.value;
        }
    }
}

