/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.componentsv2;

import java.util.Map;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.container.Container;
import net.dv8tion.jda.api.components.filedisplay.FileDisplay;
import net.dv8tion.jda.api.components.mediagallery.MediaGallery;
import net.dv8tion.jda.api.components.section.Section;
import net.dv8tion.jda.api.components.separator.Separator;
import net.dv8tion.jda.api.components.textdisplay.TextDisplay;
import net.dv8tion.jda.api.components.thumbnail.Thumbnail;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.elements.components.core.ComponentRow;
import net.itsthesky.disky.elements.componentsv2.base.ContainerBuilder;
import net.itsthesky.disky.elements.componentsv2.base.INewComponentBuilder;
import net.itsthesky.disky.elements.componentsv2.base.SectionBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.ButtonBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.FileDisplayBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.MediaGalleryBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.SeparatorBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.TextDisplayBuilder;
import net.itsthesky.disky.elements.componentsv2.base.sub.ThumbnailBuilder;
import org.jetbrains.annotations.Nullable;

public final class ComponentV2Factory {
    public static final Map<Class<? extends Component>, Class<? extends INewComponentBuilder<?>>> REGISTERED_COMPONENTS = Map.of(Container.class, ContainerBuilder.class, Section.class, SectionBuilder.class, TextDisplay.class, TextDisplayBuilder.class, Separator.class, SeparatorBuilder.class, MediaGallery.class, MediaGalleryBuilder.class, FileDisplay.class, FileDisplayBuilder.class, Button.class, ButtonBuilder.class, Thumbnail.class, ThumbnailBuilder.class, ActionRow.class, ComponentRow.class);

    public static <T extends Component> INewComponentBuilder<T> recreateComponent(@Nullable T component) {
        if (component == null) {
            return null;
        }
        try {
            Class builderClass = REGISTERED_COMPONENTS.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(component.getClass())).map(Map.Entry::getValue).findFirst().orElse(null);
            if (builderClass == null) {
                DiSky.debug("No builder registered for component: " + component.getClass().getName() + ", using default builder.");
                return null;
            }
            INewComponentBuilder builder = (INewComponentBuilder)builderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            builder.loadFrom(component);
            return builder;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to recreate component: " + component.getUniqueId(), e);
        }
    }
}

