/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.componentsv2.base;

import ch.njol.skript.util.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.dv8tion.jda.api.components.container.Container;
import net.dv8tion.jda.api.components.container.ContainerChildComponentUnion;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.componentsv2.ComponentV2Factory;
import net.itsthesky.disky.elements.componentsv2.base.IContainerComponentBuilder;
import net.itsthesky.disky.elements.componentsv2.base.INewComponentBuilder;

public class ContainerBuilder
implements INewComponentBuilder<Container> {
    private final List<IContainerComponentBuilder<?>> components = new ArrayList();
    private int uniqueId = -1;
    private boolean spoiler = false;
    private Color accentColor = null;

    public ContainerBuilder(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void addContent(IContainerComponentBuilder<?> component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        this.components.add(component);
    }

    @Override
    public void loadFrom(Container component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        this.components.clear();
        for (ContainerChildComponentUnion child : component.getComponents()) {
            INewComponentBuilder<ContainerChildComponentUnion> newComp = ComponentV2Factory.recreateComponent(child);
            if (!(newComp instanceof IContainerComponentBuilder)) continue;
            IContainerComponentBuilder builder = (IContainerComponentBuilder)newComp;
            this.components.add(builder);
        }
        this.uniqueId = component.getUniqueId();
        this.accentColor = SkriptUtils.convert(component.getAccentColor());
        this.spoiler = component.isSpoiler();
    }

    @Override
    public Container build() {
        Container base = Container.of(this.components.stream().map(INewComponentBuilder::buildWithId).collect(Collectors.toList()));
        if (this.accentColor != null) {
            base = base.withAccentColor(SkriptUtils.convert(this.accentColor));
        }
        return base.withSpoiler(this.spoiler);
    }

    @Generated
    public List<IContainerComponentBuilder<?>> getComponents() {
        return this.components;
    }

    @Override
    @Generated
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public boolean isSpoiler() {
        return this.spoiler;
    }

    @Generated
    public Color getAccentColor() {
        return this.accentColor;
    }

    @Override
    @Generated
    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setSpoiler(boolean spoiler) {
        this.spoiler = spoiler;
    }

    @Generated
    public void setAccentColor(Color accentColor) {
        this.accentColor = accentColor;
    }

    @Generated
    public ContainerBuilder() {
    }
}

