/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.componentsv2.base;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.dv8tion.jda.api.components.section.Section;
import net.dv8tion.jda.api.components.section.SectionAccessoryComponent;
import net.itsthesky.disky.elements.componentsv2.ComponentBuildException;
import net.itsthesky.disky.elements.componentsv2.ComponentV2Factory;
import net.itsthesky.disky.elements.componentsv2.base.IContainerComponentBuilder;
import net.itsthesky.disky.elements.componentsv2.base.INewComponentBuilder;
import net.itsthesky.disky.elements.componentsv2.base.ISectionAccessoryBuilder;
import net.itsthesky.disky.elements.componentsv2.base.ISectionComponentBuilder;

public class SectionBuilder
implements IContainerComponentBuilder<Section> {
    private final List<ISectionComponentBuilder<?>> components = new ArrayList();
    private ISectionAccessoryBuilder<?> accessoryComponent;
    private int uniqueId = -1;

    public void addContent(ISectionComponentBuilder<?> component) {
        this.components.add(component);
    }

    @Override
    public Section build() {
        if (this.accessoryComponent == null) {
            throw new ComponentBuildException("Section must have an accessory component set before building.");
        }
        if (this.components.isEmpty() || this.components.size() > 3) {
            throw new ComponentBuildException("Section must have between 1 and 3 content components.");
        }
        return Section.of((SectionAccessoryComponent)this.accessoryComponent.buildWithId(), this.components.stream().map(INewComponentBuilder::buildWithId).toList());
    }

    @Override
    public void loadFrom(Section component) {
        this.accessoryComponent = (ISectionAccessoryBuilder)ComponentV2Factory.recreateComponent(component.getAccessory());
        this.components.clear();
        this.components.addAll(component.getContentComponents().stream().map(comp -> (ISectionComponentBuilder)ComponentV2Factory.recreateComponent(comp)).toList());
    }

    @Generated
    public List<ISectionComponentBuilder<?>> getComponents() {
        return this.components;
    }

    @Generated
    public ISectionAccessoryBuilder<?> getAccessoryComponent() {
        return this.accessoryComponent;
    }

    @Override
    @Generated
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public void setAccessoryComponent(ISectionAccessoryBuilder<?> accessoryComponent) {
        this.accessoryComponent = accessoryComponent;
    }

    @Override
    @Generated
    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public SectionBuilder(ISectionAccessoryBuilder<?> accessoryComponent, int uniqueId) {
        this.accessoryComponent = accessoryComponent;
        this.uniqueId = uniqueId;
    }

    @Generated
    public SectionBuilder() {
    }
}

