/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.componentsv2.base.sub;

import lombok.Generated;
import net.dv8tion.jda.api.components.filedisplay.FileDisplay;
import net.dv8tion.jda.api.utils.FileUpload;
import net.itsthesky.disky.core.JDAUtils;
import net.itsthesky.disky.elements.componentsv2.base.IContainerComponentBuilder;
import org.jetbrains.annotations.Nullable;

public class FileDisplayBuilder
implements IContainerComponentBuilder<FileDisplay> {
    private FileUpload source;
    private boolean spoiler;
    private int uniqueId = -1;
    @Nullable
    private FileDisplay original;

    public FileDisplayBuilder(FileUpload source2, boolean spoiler, int uniqueId) {
        this.source = source2;
        this.spoiler = spoiler;
        this.uniqueId = uniqueId;
    }

    @Override
    public FileDisplay build() {
        return this.original == null ? FileDisplay.fromFile(this.source).withSpoiler(this.spoiler) : this.original;
    }

    @Override
    public void loadFrom(FileDisplay component) {
        this.original = component;
        this.spoiler = component.isSpoiler();
        this.uniqueId = component.getUniqueId();
    }

    public String toString() {
        return "FileDisplayBuilder{source='" + String.valueOf(this.source) + "', spoiler=" + this.spoiler + ", uniqueId=" + this.uniqueId + "}";
    }

    public String getFileName() {
        if (this.original != null) {
            String url = this.original.getUrl();
            String fileName = JDAUtils.getFileNameFromUrl(url);
            return fileName != null ? fileName : url;
        }
        return this.source.getName();
    }

    @Generated
    public FileUpload getSource() {
        return this.source;
    }

    @Generated
    public boolean isSpoiler() {
        return this.spoiler;
    }

    @Override
    @Generated
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Nullable
    @Generated
    public FileDisplay getOriginal() {
        return this.original;
    }

    @Generated
    public void setSource(FileUpload source2) {
        this.source = source2;
    }

    @Generated
    public void setSpoiler(boolean spoiler) {
        this.spoiler = spoiler;
    }

    @Override
    @Generated
    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setOriginal(@Nullable FileDisplay original) {
        this.original = original;
    }

    @Generated
    public FileDisplayBuilder() {
    }
}

