/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.componentsv2.base.sub;

import lombok.Generated;
import net.dv8tion.jda.api.components.thumbnail.Thumbnail;
import net.dv8tion.jda.api.utils.FileUpload;
import net.itsthesky.disky.elements.componentsv2.base.ISectionAccessoryBuilder;
import org.jetbrains.annotations.Nullable;

public class ThumbnailBuilder
implements ISectionAccessoryBuilder<Thumbnail> {
    private FileUpload source;
    private String rawUrl;
    private int uniqueId;
    @Nullable
    private Thumbnail component = null;

    public ThumbnailBuilder(FileUpload uploadSource, int uniqueId) {
        this.source = uploadSource;
        this.rawUrl = null;
        this.uniqueId = uniqueId;
    }

    public ThumbnailBuilder(String urlSource, int uniqueId) {
        this.source = null;
        this.rawUrl = urlSource;
        this.uniqueId = uniqueId;
    }

    @Override
    public void loadFrom(Thumbnail component) {
        this.component = component;
        this.uniqueId = component.getUniqueId();
    }

    @Override
    public Thumbnail build() {
        if (this.component != null) {
            return this.component;
        }
        if (this.rawUrl != null) {
            return Thumbnail.fromUrl(this.rawUrl);
        }
        return Thumbnail.fromFile(this.source);
    }

    public String toString() {
        return "ThumbnailBuilder{uniqueId=" + this.uniqueId + ", component=" + String.valueOf(this.component) + ", source=" + String.valueOf(this.source) + "}";
    }

    @Generated
    public ThumbnailBuilder() {
    }

    @Generated
    public void setSource(FileUpload source2) {
        this.source = source2;
    }

    @Generated
    public void setRawUrl(String rawUrl) {
        this.rawUrl = rawUrl;
    }

    @Override
    @Generated
    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setComponent(@Nullable Thumbnail component) {
        this.component = component;
    }

    @Generated
    public FileUpload getSource() {
        return this.source;
    }

    @Generated
    public String getRawUrl() {
        return this.rawUrl;
    }

    @Override
    @Generated
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Nullable
    @Generated
    public Thumbnail getComponent() {
        return this.component;
    }
}

