/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.componentsv2.skript.create;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.utils.FileUpload;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.JDAUtils;
import net.itsthesky.disky.elements.componentsv2.base.sub.FileDisplayBuilder;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExprNewFileDisplay
extends SimpleExpression<FileDisplayBuilder> {
    private boolean isSpoiler;
    private Expression<Object> exprSource;
    private Expression<Integer> exprUniqueId;
    private Node node;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        this.isSpoiler = parseResult.expr.contains("new spoiler");
        this.exprSource = exprs[0];
        this.exprUniqueId = exprs[1];
        return true;
    }

    protected FileDisplayBuilder @NotNull [] get(@NotNull Event e) {
        Integer uniqueId = EasyElement.parseSingle(this.exprUniqueId, e, -1);
        Object source2 = EasyElement.parseSingle(this.exprSource, e, null);
        if (source2 == null) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprSource);
            return new FileDisplayBuilder[0];
        }
        FileUpload fileUpload = null;
        if (source2 instanceof String) {
            String raw = source2;
            fileUpload = JDAUtils.parseFile(raw);
        } else if (source2 instanceof FileUpload) {
            FileUpload upload;
            fileUpload = upload = (FileUpload)source2;
        }
        if (fileUpload == null) {
            return new FileDisplayBuilder[0];
        }
        return new FileDisplayBuilder[]{new FileDisplayBuilder(fileUpload, this.isSpoiler, uniqueId)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends FileDisplayBuilder> getReturnType() {
        return FileDisplayBuilder.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "new " + (this.isSpoiler ? "spoiler " : "") + "file display with source " + this.exprSource.toString(event, debug) + (String)(this.exprUniqueId != null ? " with unique id " + this.exprUniqueId.toString(event, debug) : "");
    }

    static {
        Skript.registerExpression(ExprNewFileDisplay.class, FileDisplayBuilder.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] new [spoiler] file display [with [the] source] %string/fileupload% [with [unique] id %-integer%]"});
    }
}

