/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.componentsv2.skript.create;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.utils.FileUpload;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.componentsv2.base.sub.ThumbnailBuilder;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExprNewThumbnail
extends SimpleExpression<ThumbnailBuilder> {
    private Expression<Object> exprSource;
    private Expression<Integer> exprUniqueId;
    private Node node;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        this.exprSource = exprs[0];
        this.exprUniqueId = exprs[1];
        return true;
    }

    protected ThumbnailBuilder @NotNull [] get(@NotNull Event e) {
        Integer uniqueId = EasyElement.parseSingle(this.exprUniqueId, e, -1);
        Object source2 = EasyElement.parseSingle(this.exprSource, e, null);
        if (source2 == null) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprSource);
            return new ThumbnailBuilder[0];
        }
        if (source2 instanceof FileUpload) {
            FileUpload upload = source2;
            return new ThumbnailBuilder[]{new ThumbnailBuilder(upload, (int)uniqueId)};
        }
        if (source2 instanceof String) {
            String url = source2;
            return new ThumbnailBuilder[]{new ThumbnailBuilder(url, (int)uniqueId)};
        }
        DiSkyRuntimeHandler.error(new IllegalArgumentException("The source of a thumbnail must be a FileUpload or a String (url)."));
        return new ThumbnailBuilder[0];
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ThumbnailBuilder> getReturnType() {
        return ThumbnailBuilder.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "new thumbnail display with source " + this.exprSource.toString(event, debug) + (String)(this.exprUniqueId != null ? " with unique id " + this.exprUniqueId.toString(event, debug) : "");
    }

    static {
        Skript.registerExpression(ExprNewThumbnail.class, ThumbnailBuilder.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] new thumbnail [display] [with [the] (source|url)] %fileupload/string% [with [unique] id %-integer%]"});
    }
}

