/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.componentsv2.skript.replacement;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.MessageTopLevelComponentUnion;
import net.dv8tion.jda.api.components.container.Container;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.callbacks.IMessageEditCallback;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.specific.ComponentInteractionEvent;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.components.core.ComponentRow;
import net.itsthesky.disky.elements.componentsv2.ComponentV2Factory;
import net.itsthesky.disky.elements.componentsv2.base.ContainerBuilder;
import net.itsthesky.disky.elements.componentsv2.base.IContainerComponentBuilder;
import net.itsthesky.disky.elements.componentsv2.base.INewComponentBuilder;
import net.itsthesky.disky.elements.componentsv2.base.ISectionAccessoryBuilder;
import net.itsthesky.disky.elements.componentsv2.base.ISectionComponentBuilder;
import net.itsthesky.disky.elements.componentsv2.base.SectionBuilder;
import net.itsthesky.disky.elements.componentsv2.skript.replacement.EvtMsgReplacement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecApplyReplacement
extends Section {
    private Expression<Message> exprMessage;
    private Trigger trigger;
    private INewComponentBuilder<?> nextNewComponent;
    private boolean hasChanged = false;

    public static Component doReplacement(@NotNull Component component, @NotNull Function<INewComponentBuilder<?>, ComponentReplacerResult> replacer) {
        if (component instanceof Container) {
            Container container2 = (Container)component;
            ContainerBuilder containerBuilder = (ContainerBuilder)ComponentV2Factory.recreateComponent(container2);
            ComponentReplacerResult result2 = replacer.apply(containerBuilder);
            if (!result2.hasChanged()) {
                return containerBuilder.buildWithId();
            }
            ContainerBuilder replacedBuilder = (ContainerBuilder)result2.newComponent();
            if (containerBuilder != replacedBuilder) {
                return replacedBuilder.buildWithId();
            }
            replacedBuilder.getComponents().clear();
            for (Component component2 : container2.getComponents()) {
                Component replacedChild = SecApplyReplacement.doReplacement(component2, replacer);
                if (replacedChild == null) continue;
                INewComponentBuilder<Component> childBuilder = ComponentV2Factory.recreateComponent(replacedChild);
                replacedBuilder.addContent(childBuilder == null ? null : (IContainerComponentBuilder)childBuilder);
            }
            return replacedBuilder.buildWithId();
        }
        if (component instanceof net.dv8tion.jda.api.components.section.Section) {
            net.dv8tion.jda.api.components.section.Section section2 = (net.dv8tion.jda.api.components.section.Section)component;
            SectionBuilder sectionBuilder = (SectionBuilder)ComponentV2Factory.recreateComponent(section2);
            ComponentReplacerResult result3 = replacer.apply(sectionBuilder);
            if (!result3.hasChanged()) {
                return sectionBuilder.buildWithId();
            }
            SectionBuilder replacedBuilder = (SectionBuilder)result3.newComponent();
            if (sectionBuilder != replacedBuilder) {
                return replacedBuilder.buildWithId();
            }
            replacedBuilder.getComponents().clear();
            for (Component component3 : section2.getContentComponents()) {
                Component replacedChild = SecApplyReplacement.doReplacement(component3, replacer);
                if (replacedChild == null) continue;
                INewComponentBuilder<Component> childBuilder = ComponentV2Factory.recreateComponent(replacedChild);
                replacedBuilder.addContent(childBuilder == null ? null : (ISectionComponentBuilder)childBuilder);
            }
            ISectionAccessoryBuilder accessoryBuilder = (ISectionAccessoryBuilder)ComponentV2Factory.recreateComponent(section2.getAccessory());
            if (accessoryBuilder != null) {
                ComponentReplacerResult componentReplacerResult = replacer.apply(accessoryBuilder);
                if (!componentReplacerResult.hasChanged()) {
                    return replacedBuilder.buildWithId();
                }
                INewComponentBuilder<?> replacedAccessory = componentReplacerResult.newComponent();
                if (replacedAccessory == null) {
                    return null;
                }
                if (replacedAccessory instanceof ComponentRow) {
                    ComponentRow componentRow = (ComponentRow)replacedAccessory;
                    replacedBuilder.setAccessoryComponent((ISectionAccessoryBuilder)INewComponentBuilder.of(componentRow.getSingleButton()));
                } else {
                    replacedBuilder.setAccessoryComponent((ISectionAccessoryBuilder)replacedAccessory);
                }
            }
            if (replacedBuilder.getAccessoryComponent() == null) {
                return null;
            }
            return replacedBuilder.buildWithId();
        }
        INewComponentBuilder<Component> componentBuilder = ComponentV2Factory.recreateComponent(component);
        ComponentReplacerResult result4 = replacer.apply(componentBuilder);
        if (!result4.hasChanged()) {
            return componentBuilder.buildWithId();
        }
        INewComponentBuilder<?> replacedBuilder = result4.newComponent();
        if (componentBuilder != replacedBuilder) {
            return replacedBuilder.buildWithId();
        }
        return null;
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        this.exprMessage = expressions[0];
        this.trigger = SkriptUtils.loadCode(sectionNode, this, "apply replacement", parser -> parser.setCurrentSections(List.of(this)), null, EvtMsgReplacement.class);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Message message2 = (Message)this.exprMessage.getSingle(event);
        if (message2 == null) {
            return this.getNext();
        }
        Function<INewComponentBuilder<?>, ComponentReplacerResult> replacer = builder -> {
            EvtMsgReplacement evt = new EvtMsgReplacement(builder.getUniqueId(), (INewComponentBuilder<?>)builder, null);
            Object vars = Variables.copyLocalVariables((Event)event);
            if (vars != null) {
                Variables.setLocalVariables((Event)evt, (Object)vars);
            }
            this.nextNewComponent = builder;
            this.hasChanged = false;
            TriggerItem.walk((TriggerItem)this.trigger, (Event)evt);
            return new ComponentReplacerResult(this.nextNewComponent, this.hasChanged);
        };
        ArrayList<MessageTopLevelComponent> replacedTree = new ArrayList<MessageTopLevelComponent>();
        for (MessageTopLevelComponentUnion topLevelComp : message2.getComponents()) {
            Component replaced = SecApplyReplacement.doReplacement(topLevelComp, replacer);
            if (replaced == null) {
                DiSky.debug("Component " + topLevelComp.getClass().getSimpleName() + " was replaced to null, skipping.");
                continue;
            }
            replacedTree.add((MessageTopLevelComponent)replaced);
        }
        SkriptUtils.async(() -> {
            RestAction action = (RestAction)message2.editMessageComponents(replacedTree).useComponentsV2();
            DiSky.debug("Got event " + event.getClass().getSimpleName() + " with interfaces:");
            for (Class<?> iface : event.getClass().getInterfaces()) {
                DiSky.debug(" - " + iface.getSimpleName());
            }
            if (event instanceof ComponentInteractionEvent) {
                ComponentInteractionEvent interactionEvent = (ComponentInteractionEvent)event;
                Interaction interaction = interactionEvent.getInteractionEvent().getInteraction();
                DiSky.debug("Editing via interaction, components for interaction: " + interaction.getClass().getSimpleName());
                if (interaction instanceof IMessageEditCallback) {
                    IMessageEditCallback messageEditCallback = (IMessageEditCallback)interaction;
                    DiSky.debug("Editing via interaction, components for interaction: " + interaction.getId());
                    action = (RestAction)messageEditCallback.editComponents(replacedTree).useComponentsV2();
                } else {
                    DiSky.debug("Editing component via normal mesages :)");
                }
            }
            try {
                action.complete();
            }
            catch (ErrorResponseException e) {
                if (e.getErrorResponse() == ErrorResponse.INVALID_FORM_BODY) {
                    DataObject responseDataObject = e.getResponse().getObject();
                    DataObject data = responseDataObject.getObject("errors").getObject("data");
                    for (String key : data.keys()) {
                        DiSky.debug("Error in component: " + key + " - " + String.valueOf(data.getObject(key)));
                    }
                }
                throw new RuntimeException("Failed to apply replacement to message: " + message2.getId(), e);
            }
            SkriptUtils.sync(() -> TriggerItem.walk((TriggerItem)this.getNext(), (Event)event));
        });
        return null;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "apply the replacement for the message " + this.exprMessage.toString(event, debug);
    }

    @Generated
    public void setNextNewComponent(INewComponentBuilder<?> nextNewComponent) {
        this.nextNewComponent = nextNewComponent;
    }

    @Generated
    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    static {
        Skript.registerSection(SecApplyReplacement.class, (String[])new String[]{"apply component[s] [the] replacement[s] (to|for) [the] [message] %message%"});
    }

    public record ComponentReplacerResult(@NotNull INewComponentBuilder<?> newComponent, boolean hasChanged) {
    }
}

