/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.CondPermission;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.DiSkyRegistry;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.registration.SyntaxRegistry;

@Name(value="Member Has Permissions")
@Description(value={"Check if a member has permissions in an optional channel."})
@Examples(value={"if event-member has discord permission administrator: # global permission", "if event-member has discord permission send message in event-channel: # channel specific permission"})
public class HasPermissions
extends Condition {
    private Expression<Object> exprEntities;
    private Expression<Object> exprPerms;
    private Expression<GuildChannel> exprChannel;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprEntities = exprs[0];
        this.exprPerms = exprs[1];
        this.exprChannel = exprs[2];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.exprEntities.check(event, rawEntity -> this.exprPerms.check(event, rawPermission -> {
            if (rawEntity == null || rawPermission == null) {
                return this.isNegated();
            }
            if (rawEntity instanceof Member) {
                GuildChannel channel;
                Member member = (Member)rawEntity;
                Permission permissions = (Permission)((Object)((Object)((Object)rawPermission)));
                GuildChannel guildChannel = channel = this.exprChannel == null ? null : (GuildChannel)this.exprChannel.getSingle(event);
                if (channel == null) {
                    return member.hasPermission(permissions);
                }
                return member.hasPermission(channel, permissions);
            }
            if (rawEntity instanceof CommandSender) {
                CommandSender s = (CommandSender)rawEntity;
                String perm = (String)rawPermission;
                if (s.hasPermission(perm)) {
                    return true;
                }
                if (perm.startsWith("skript.")) {
                    int i = perm.lastIndexOf(46);
                    while (i != -1) {
                        if (s.hasPermission(perm.substring(0, i + 1) + "*")) {
                            return true;
                        }
                        i = perm.lastIndexOf(46, i - 1);
                    }
                }
            }
            return false;
        }), this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return this.exprEntities.toString(event, debug) + " has permission " + this.exprPerms.toString(event, debug) + (String)(this.exprChannel == null ? "" : " in channel " + this.exprChannel.toString(event, debug));
    }

    static {
        if (DiSkyRegistry.unregisterElement(SyntaxRegistry.CONDITION, CondPermission.class)) {
            Skript.registerCondition(HasPermissions.class, (String[])new String[]{"%commandsenders/members% (has|have) [the] [discord] permission[s] %strings/permissions% [in [the] [channel] %-guildchannel%]", "%commandsenders/members% (doesn't|does not|do not|don't) have [the] [discord] permission[s] %strings/permissions% [in [the] [channel] %-guildchannel%]"});
            DiSky.debug("Successfully unregistered the 'has permission' condition to register the new one.");
        } else {
            Skript.error((String)"Cannot register the 'has permission' condition since the original one cannot be unregistered! We'll register the default one instead.");
            PropertyCondition.register(HasPermissions.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (String)"discord permission[s] %permissions% [in [the] [channel] %-guildchannel%]", (String)"member");
        }
    }
}

