/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.EasyPropertyCondition;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Member Has Role")
@Description(value={"Check if a member has a specific role."})
@Examples(value={"if event-member has discord role with id \"000\":"})
public class HasRole
extends EasyPropertyCondition<Member> {
    private Expression<Role> exprRole;

    @Override
    public boolean check(Event e, Member entity) {
        Role target = EasyElement.parseSingle(this.exprRole, e, null);
        if (target == null || entity == null) {
            return false;
        }
        return entity.getRoles().stream().anyMatch(role -> role.getId().equalsIgnoreCase(target.getId()));
    }

    @Override
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprRole = exprs[1];
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    static {
        HasRole.register(HasRole.class, PropertyCondition.PropertyType.HAVE, "discord [role] %role%", "member");
    }
}

