/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.datastructs;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Color;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.managers.RoleManager;
import net.dv8tion.jda.api.requests.restaction.RoleAction;
import net.itsthesky.disky.api.datastruct.ChainDataStructElement;
import net.itsthesky.disky.api.datastruct.DataStructureEntry;
import net.itsthesky.disky.api.datastruct.base.ChainDS;
import net.itsthesky.disky.api.datastruct.base.EditableDataStructure;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoleDS
extends ChainDataStructElement<Role, RoleWrapper, RoleStructure> {
    private Expression<Guild> exprGuild;
    private Expression<Role> exprRole;
    private boolean copy;

    @Override
    public boolean init(Expression<?>[] expressions, int pattern, Kleenean delayed, SkriptParser.ParseResult result2, @Nullable SectionNode node, @Nullable List<TriggerItem> triggerItems) {
        if (!super.init(expressions, pattern, delayed, result2, node, triggerItems)) {
            return false;
        }
        boolean bl = this.copy = pattern == 1;
        if (this.copy) {
            this.exprRole = expressions[0];
            this.exprGuild = expressions[1];
        } else {
            this.exprGuild = expressions[0];
        }
        return true;
    }

    @Override
    public RoleWrapper getOriginalInstance(@NotNull Event event) {
        Guild guild = EasyElement.parseSingle(this.exprGuild, event);
        Role role = EasyElement.parseSingle(this.exprRole, event);
        if (guild == null) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprGuild);
            return null;
        }
        if (this.copy && role == null) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprRole);
            return null;
        }
        if (this.copy && !role.getGuild().getId().equals(guild.getId())) {
            DiSkyRuntimeHandler.error(new IllegalStateException("Cannot copy a role from a different guild! Got role from guild '" + role.getGuild().getName() + "' and trying to copy it into '" + guild.getName() + "'!"), this.node);
            return null;
        }
        return new RoleWrapper(this.copy ? guild.createCopyOfRole(role) : guild.createRole());
    }

    @Override
    public Role applyChanges(@NotNull Event event, @NotNull RoleWrapper edited) {
        return (Role)edited.getAction().complete();
    }

    @Override
    public Class<RoleStructure> getDataStructClass() {
        return RoleStructure.class;
    }

    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "role data structure";
    }

    static {
        Skript.registerExpression(RoleDS.class, Role.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] new role in [the] [guild] %guild%", "[a] new role (using|copying) %role% in [the] [guild] %guild%"});
    }

    public static class RoleWrapper {
        @Nullable
        private RoleAction action;
        @Nullable
        private RoleManager manager;

        private RoleWrapper(@Nullable RoleAction action, @Nullable RoleManager manager) {
            this.action = action;
            this.manager = manager;
        }

        public RoleWrapper(@NotNull RoleAction action) {
            this(action, null);
        }

        public RoleWrapper(@NotNull RoleManager manager) {
            this(null, manager);
        }

        public void setName(String name) {
            if (this.action != null) {
                this.action.setName(name);
            } else if (this.manager != null) {
                this.manager.setName(name);
            }
        }

        public void setColor(Color color) {
            if (this.action != null) {
                this.action.setColor(SkriptUtils.convert(color));
            } else if (this.manager != null) {
                this.manager.setColor(SkriptUtils.convert(color));
            }
        }

        public void setHoisted(boolean hoist) {
            if (this.action != null) {
                this.action.setHoisted(hoist);
            } else if (this.manager != null) {
                this.manager.setHoisted(hoist);
            }
        }

        public void setMentionable(boolean mentionable) {
            if (this.action != null) {
                this.action.setMentionable(mentionable);
            } else if (this.manager != null) {
                this.manager.setMentionable(mentionable);
            }
        }

        public void setPermissions(List<Permission> permissions) {
            if (this.action != null) {
                this.action.setPermissions(permissions);
            } else if (this.manager != null) {
                this.manager.setPermissions(permissions);
            }
        }

        @Nullable
        public RoleManager getManager() {
            return this.manager;
        }

        @Nullable
        public RoleAction getAction() {
            return this.action;
        }
    }

    public static class RoleStructure
    implements ChainDS<RoleWrapper>,
    EditableDataStructure<RoleWrapper, RoleStructure> {
        @DataStructureEntry(value="name")
        public String name;
        @DataStructureEntry(value="color")
        public Color color;
        @DataStructureEntry(value="hoist")
        public Boolean hoist;
        @DataStructureEntry(value="mentionable")
        public Boolean mentionable;
        @DataStructureEntry(value="permissions")
        public List<Permission> permissions;

        @Override
        public RoleWrapper edit(RoleWrapper original) {
            if (this.name != null) {
                original.setName(this.name);
            }
            if (this.color != null) {
                original.setColor(this.color);
            }
            if (this.hoist != null) {
                original.setHoisted(this.hoist);
            }
            if (this.mentionable != null) {
                original.setMentionable(this.mentionable);
            }
            if (this.permissions != null) {
                original.setPermissions(this.permissions);
            }
            return original;
        }

        @Override
        public List<Class<?>> getAcceptedClasses() {
            return List.of(Role.class);
        }

        @Override
        public RoleWrapper convert(@NotNull Object object) {
            if (!(object instanceof Role)) {
                throw new IllegalArgumentException("The object to convert must be a role!");
            }
            return new RoleWrapper(((Role)object).getManager());
        }
    }
}

