/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.datastructs.structures;

import java.util.List;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.buttons.ButtonStyle;
import net.itsthesky.disky.api.datastruct.DataStructureEntry;
import net.itsthesky.disky.api.datastruct.base.BasicDS;
import net.itsthesky.disky.api.emojis.Emote;
import org.jetbrains.annotations.Nullable;

public class ButtonStructure
implements BasicDS<Button> {
    @DataStructureEntry(value="emote", description="The emoji/emote of the button. If this is not set, the button MUST have a label.")
    public Emote emoji;
    @DataStructureEntry(value="label", description="The label of the button. If this is not set, the button MUST have an emoji.")
    public String label;
    @DataStructureEntry(value="style", optional=false, description="The style of the button.")
    public ButtonStyle style;
    @DataStructureEntry(value="url", description="The URL of the button. If this is set, the button will be a link button and the style will be ignored. If this is null, the button must have an ID.")
    public String url;
    @DataStructureEntry(value="disabled", description="Whether the button is disabled or not.")
    public Boolean disabled = false;
    @DataStructureEntry(value="id", description="The ID of the button to represent it. Must be unique within all a message's components. If this is null, the URL must be set.")
    public String id;

    @Override
    @Nullable
    public String preValidate(List<String> presentKeys) {
        if (!presentKeys.contains("label") && !presentKeys.contains("emote")) {
            return "The button must have a label or an emoji. None of them are present.";
        }
        if (!presentKeys.contains("id") && !presentKeys.contains("url")) {
            return "The button must have an ID or an URL. None of them are present.";
        }
        return null;
    }

    @Override
    public Button build() {
        Button button;
        String idOrUrl = this.id == null ? this.url : this.id;
        Button button2 = button = this.label == null ? Button.of(this.style, idOrUrl, this.emoji.getEmoji()) : Button.of(this.style, idOrUrl, this.label);
        if (this.label != null && this.emoji != null) {
            button = Button.of(this.style, idOrUrl, this.label, this.emoji.getEmoji());
        }
        if (this.disabled.booleanValue()) {
            button = button.asDisabled();
        }
        return button;
    }
}

