/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.datastructs.structures;

import ch.njol.skript.util.Color;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.SkriptColor;
import java.time.Instant;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.itsthesky.disky.api.EmbedManager;
import net.itsthesky.disky.api.datastruct.DataStructure;
import net.itsthesky.disky.api.datastruct.DataStructureEntry;
import net.itsthesky.disky.api.datastruct.base.BasicDS;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.datastructs.structures.EmbedFieldStructure;

@DataStructure(clazz=EmbedBuilder.class)
public class EmbedStructure
implements BasicDS<EmbedBuilder> {
    @DataStructureEntry(value="title")
    public String title;
    @DataStructureEntry(value="url")
    public String url;
    @DataStructureEntry(value="description")
    public String description;
    @DataStructureEntry(value="footer")
    public String footer;
    @DataStructureEntry(value="footer icon")
    public String footerIcon;
    @DataStructureEntry(value="thumbnail")
    public String thumbnail;
    @DataStructureEntry(value="image")
    public String image;
    @DataStructureEntry(value="author")
    public String author;
    @DataStructureEntry(value="author icon")
    public String authorIcon;
    @DataStructureEntry(value="author url")
    public String authorUrl;
    @DataStructureEntry(value="timestamp")
    public Date timestamp;
    @DataStructureEntry(value="color")
    public Color color = SkriptColor.YELLOW;
    @DataStructureEntry(value="field", subStructureType=EmbedFieldStructure.class)
    public List<MessageEmbed.Field> fields;
    @DataStructureEntry(value="template")
    public String template;

    @Override
    public EmbedBuilder build() {
        EmbedBuilder builder = EmbedManager.getTemplate(this.template);
        if (this.title != null) {
            builder.setTitle(this.title);
        }
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        if (this.color != null) {
            builder.setColor(SkriptUtils.convert(this.color));
        }
        if (this.footer != null) {
            if (this.footerIcon != null) {
                builder.setFooter(this.footer, this.footerIcon);
            } else {
                builder.setFooter(this.footer);
            }
        }
        if (this.author != null) {
            if (this.authorIcon != null) {
                if (this.authorUrl != null) {
                    builder.setAuthor(this.author, this.authorUrl, this.authorIcon);
                } else {
                    builder.setAuthor(this.author, null, this.authorIcon);
                }
            } else if (this.authorUrl != null) {
                builder.setAuthor(this.author, this.authorUrl);
            } else {
                builder.setAuthor(this.author);
            }
        }
        if (this.thumbnail != null) {
            builder.setThumbnail(this.thumbnail);
        }
        if (this.image != null) {
            builder.setImage(this.image);
        }
        if (this.timestamp != null) {
            builder.setTimestamp(Instant.ofEpochMilli(this.timestamp.getTime()));
        }
        if (this.fields != null) {
            for (MessageEmbed.Field field : this.fields) {
                builder.addField(field);
            }
        }
        return builder;
    }
}

