/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Ban Member")
@Description(value={"Bans a member or the given user ID from a guild."})
@Examples(value={"ban discord event-member because of \"being lame\" and delete 10 days worth of messages"})
public class BanMember
extends AsyncEffect {
    private Node node;
    private boolean usingUserId;
    private Expression<Object> exprTarget;
    private Expression<String> exprReason;
    private Expression<Timespan> exprDays;
    private Expression<Guild> exprGuild;

    public boolean init(Expression[] expr, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.usingUserId = matchedPattern == 1;
        this.node = this.getParser().getNode();
        this.exprTarget = expr[0];
        if (this.usingUserId) {
            this.exprGuild = expr[1];
            this.exprReason = expr[2];
        } else {
            this.exprReason = expr[1];
            this.exprDays = expr[2];
        }
        return true;
    }

    public void execute(@NotNull Event e) {
        String reason;
        Object target = this.exprTarget.getSingle(e);
        String string = reason = this.exprReason == null ? null : (String)this.exprReason.getSingle(e);
        if (target == null) {
            return;
        }
        if (this.usingUserId) {
            Guild guild = (Guild)this.exprGuild.getSingle(e);
            if (guild == null) {
                DiSkyRuntimeHandler.error(new NullPointerException("DiSky cannot ban the user ID '" + String.valueOf(target) + "' because the given guild is null!"), this.node);
                return;
            }
            guild.ban(UserSnowflake.fromId((String)target), 0, TimeUnit.MILLISECONDS).reason(reason).complete();
        } else {
            Member member = (Member)target;
            Timespan timespan = (Timespan)this.exprDays.getSingle(e);
            member.ban(timespan == null ? 0 : (int)timespan.getAs(Timespan.TimePeriod.MILLISECOND), TimeUnit.MILLISECONDS).reason(reason).complete();
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        if (this.usingUserId) {
            return "ban member " + this.exprTarget.toString(e, debug) + " from guild " + this.exprGuild.toString(e, debug) + (String)(this.exprReason == null ? "" : " with reason " + this.exprReason.toString(e, debug));
        }
        return "ban member " + this.exprTarget.toString(e, debug) + (String)(this.exprReason == null ? "" : " with reason " + this.exprReason.toString(e, debug)) + " and delete " + this.exprDays.toString(e, debug) + " worth of messages";
    }

    static {
        Skript.registerEffect(BanMember.class, (String[])new String[]{"[discord] ban [the] discord [member] %member% [(due to|because of|with [the] reason) %-string%] [and (delete|remove) %-timespan% [worth ]of messages]", "[discord] ban [the] discord [member] %string% (from|of) [the] [guild] %guild% [(due to|because of|with [the] reason) %-string%]"});
    }
}

