/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.channel.attribute.IInviteContainer;
import net.dv8tion.jda.api.requests.restaction.InviteAction;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateInvite
extends AsyncEffect {
    private Node node;
    private Expression<Object> exprEntity;
    private Expression<Number> exprMaxUses;
    private Expression<Timespan> exprMaxAge;
    private Expression<Object> exprResult;

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "create invite in " + this.exprEntity.toString(e, debug) + " with max uses " + this.exprMaxUses.toString(e, debug) + " with max age " + this.exprMaxAge.toString(e, debug) + " and store it in " + this.exprResult.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprEntity = exprs[0];
        this.exprMaxUses = exprs[1];
        this.exprMaxAge = exprs[2];
        this.exprResult = exprs[3];
        this.node = this.getParser().getNode();
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Invite.class});
    }

    public void execute(@NotNull Event e) {
        Invite invite;
        Object entity = this.exprEntity.getSingle(e);
        Number maxUses = EasyElement.parseSingle(this.exprMaxUses, e, null);
        Timespan maxAge = EasyElement.parseSingle(this.exprMaxAge, e, null);
        if (EasyElement.anyNull((Object)this, entity)) {
            return;
        }
        if (!(entity instanceof IInviteContainer) && !(entity instanceof Guild)) {
            SkriptUtils.error(this.node, "The entity must be a guild or a channel to create an invite!");
            return;
        }
        if (entity instanceof Guild) {
            SkriptUtils.warning(this.node, "Creating an invite via a guild is now Deprecated. This will use the default channel of the guild. Please use a channel instead!");
            if (((Guild)entity).getDefaultChannel() == null) {
                Skript.error((String)"The default channel of the guild is null, so the invite cannot be created. Please specify a channel!");
                return;
            }
        }
        try {
            InviteAction inviteAction = entity instanceof Guild ? ((Guild)entity).getDefaultChannel().createInvite() : ((IInviteContainer)entity).createInvite();
            invite = (Invite)inviteAction.setMaxUses(maxUses == null ? null : Integer.valueOf(maxUses.intValue())).setMaxAge(maxAge == null ? null : Integer.valueOf((int)(maxAge.getAs(Timespan.TimePeriod.MILLISECOND) / 1000L))).complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        this.exprResult.change(e, (Object[])new Invite[]{invite}, Changer.ChangeMode.SET);
    }

    static {
        Skript.registerEffect(CreateInvite.class, (String[])new String[]{"(make|create) [the] [new] invite in [the] [(guild|channel)] %guild/channel% [with max us(e|age)[s] %-number%] [with max (time|age) %-timespan%] and store (it|the invite) in %~objects%"});
    }
}

