/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.forums.ForumPost;
import net.dv8tion.jda.api.entities.channel.forums.ForumTag;
import net.dv8tion.jda.api.entities.channel.forums.ForumTagSnowflake;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Create Post")
@Description(value={"Create a new post in a forum channel. The output value will be the newly created thread channel."})
@Since(value={"4.4.4"})
@Examples(value={"create a new post in forum channel with id \"000\" named \"I need help!\" with message \"please help me!\"", "create a new post in forum channel with id \"000\" named \"I need help!\" with message \"please help me!\" with tags \"help\" and \"support\""})
public class CreatePost
extends AsyncEffect {
    private Expression<ForumChannel> exprChannel;
    private Expression<String> exprName;
    private Expression<Object> exprMessage;
    private Expression<String> exprTags;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprChannel = expressions[0];
        this.exprName = expressions[1];
        this.exprMessage = expressions[2];
        this.exprTags = expressions[3];
        this.exprResult = expressions[4];
        return this.exprResult == null || Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{ThreadChannel.class});
    }

    public void execute(@NotNull Event e) {
        ThreadChannel threadChannel;
        ForumChannel channel = EasyElement.parseSingle(this.exprChannel, e);
        String name = EasyElement.parseSingle(this.exprName, e);
        Object message2 = EasyElement.parseSingle(this.exprMessage, e);
        String[] tags = EasyElement.parseList(this.exprTags, e, new String[0]);
        if (EasyElement.anyNull((Object)this, channel, message2, name)) {
            return;
        }
        MessageCreateBuilder builder = message2 instanceof MessageCreateBuilder ? (MessageCreateBuilder)message2 : (message2 instanceof EmbedBuilder ? (MessageCreateBuilder)new MessageCreateBuilder().addEmbeds(((EmbedBuilder)message2).build()) : (MessageCreateBuilder)new MessageCreateBuilder().setContent((String)message2));
        ArrayList<Object> parsedTags = new ArrayList<Object>();
        for (String input : tags) {
            List<ForumTag> tag2;
            Matcher numeral = Pattern.compile("^([0-9]+)$").matcher(input);
            if (numeral.matches()) {
                tag2 = channel.getAvailableTagById(input);
                if (tag2 == null) {
                    Skript.warning((String)("The tag with ID " + input + " doesn't exist in the channel " + channel.getName() + "!"));
                    continue;
                }
                parsedTags.add(tag2);
                continue;
            }
            tag2 = channel.getAvailableTagsByName(input, true);
            if (tag2.isEmpty()) {
                Skript.warning((String)("The tag with name " + input + " doesn't exist in the channel " + channel.getName() + "!"));
                continue;
            }
            parsedTags.add((ForumTag)tag2.get(0));
        }
        if (channel.isTagRequired() && parsedTags.isEmpty()) {
            Skript.warning((String)("The forum " + channel.getName() + " requires at least one tag to create a post (you provided none)!"));
            return;
        }
        try {
            threadChannel = ((ForumPost)channel.createForumPost(name, builder.build()).setTags(parsedTags.stream().map(tag -> ForumTagSnowflake.fromId(tag.getId())).collect(Collectors.toList())).complete()).getThreadChannel();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        if (this.exprResult != null) {
            this.exprResult.change(e, (Object[])new ThreadChannel[]{threadChannel}, Changer.ChangeMode.SET);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "create a new post in channel " + this.exprChannel.toString(e, debug) + " with name " + this.exprName.toString(e, debug) + " with message " + this.exprMessage.toString(e, debug) + " with tags " + this.exprTags.toString(e, debug) + " and store it in " + this.exprResult.toString(e, debug);
    }

    static {
        Skript.registerEffect(CreatePost.class, (String[])new String[]{"create [a] [new] post in [channel] %forumchannel% (with name|named) %string% [with message] %string/messagecreatebuilder/embedbuilder% [with [the] tags %-strings%] [and store (it|the thread) in %~-objects%]"});
    }
}

