/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.middleman.StandardGuildMessageChannel;
import net.dv8tion.jda.api.requests.restaction.ThreadChannelAction;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Create Thread")
@Description(value={"Create a new thread in a text channel with a base name.", "The bot used in that effect will automatically join the thread, so you don't have to make it join yourself.", "If you create a private thread, then you cannot specify a message.", "Else, the Thread will be created based on the specified message.", "Creating private thread need the guild to be level 2 or more, else it'll throw an exception."})
public class CreateThread
extends AsyncEffect {
    private Expression<String> exprName;
    private Expression<Message> exprMessage;
    private Expression<StandardGuildMessageChannel> exprChannel;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;
    private boolean isPrivate = false;

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "create new role named " + this.exprName.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprName = exprs[0];
        this.exprChannel = exprs[1];
        this.exprMessage = exprs[2];
        this.exprBot = exprs[3];
        this.exprResult = exprs[4];
        this.isPrivate = parseResult.hasTag("1");
        return this.exprResult == null || Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{ThreadChannel.class});
    }

    public void execute(@NotNull Event e) {
        ThreadChannel threadChannel;
        StandardGuildMessageChannel channel;
        String name = (String)this.exprName.getSingle(e);
        @Nullable Message message2 = EasyElement.parseSingle(this.exprMessage, e, null);
        Bot bot = Bot.fromContext(this.exprBot, e);
        if (EasyElement.anyNull((Object)this, bot, name, channel = (StandardGuildMessageChannel)this.exprChannel.getSingle(e))) {
            return;
        }
        channel = bot.getInstance().getChannelById(StandardGuildMessageChannel.class, channel.getId());
        if (channel == null) {
            return;
        }
        ThreadChannelAction action = this.isPrivate ? channel.createThreadChannel(name, this.isPrivate) : (message2 == null ? channel.createThreadChannel(name) : channel.createThreadChannel(name, message2.getId()));
        try {
            threadChannel = (ThreadChannel)action.complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        if (this.exprResult != null) {
            this.exprResult.change(e, (Object[])new ThreadChannel[]{threadChannel}, Changer.ChangeMode.SET);
        }
    }

    static {
        Skript.registerEffect(CreateThread.class, (String[])new String[]{"(make|create) [the] [new] [1:private] thread (named|with name) %string% in [the] [channel] %channel/textchannel% [(with|using) [the] [message] [as reference] %-message%] [(with|using) [the] [bot] %-bot%] [and store (it|the thread) in %-~objects%]"});
    }
}

