/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageEditAction;
import net.dv8tion.jda.api.requests.restaction.interactions.MessageEditCallbackAction;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.events.specific.InteractionEvent;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.componentsv2.base.ContainerBuilder;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import net.itsthesky.disky.managers.wrappers.RegisteredWebhook;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Edit Message")
@Description(value={"Edit a specific message/interaction hook to show a new rich or simple message.", "The interaction hook will only be editable for the next 15 minutes once it's sent!"})
@Examples(value={"# We are in a slash command event!\nreply with hidden \"Wanna see a magic trick? ...\" and store it in {_msg}\nwait a second\n# The variable does not contains a 'real' message, it contains the interaction hook.edit {_msg} to show \"Abracadabra!\""})
@Since(value={"4.4.0"})
public class EditMessage
extends AsyncEffect {
    private Expression<Object> exprTarget;
    private Expression<Object> exprMessage;
    private boolean direct = false;
    private boolean replace = false;
    private Node node;

    public boolean init(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprTarget = expressions[0];
        this.exprMessage = expressions[1];
        this.direct = parseResult.hasTag("direct");
        this.replace = parseResult.hasTag("replace");
        this.node = this.getParser().getNode();
        return true;
    }

    public void execute(@NotNull Event e) {
        Interaction interaction;
        Object target = EasyElement.parseSingle(this.exprTarget, e);
        Object message2 = EasyElement.parseSingle(this.exprMessage, e);
        if (message2 == null || target == null) {
            return;
        }
        MessageCreateBuilder builder = message2 instanceof MessageCreateBuilder ? (MessageCreateBuilder)message2 : (message2 instanceof EmbedBuilder ? (MessageCreateBuilder)new MessageCreateBuilder().addEmbeds(((EmbedBuilder)message2).build()) : (message2 instanceof ContainerBuilder ? (MessageCreateBuilder)((MessageCreateBuilder)new MessageCreateBuilder().useComponentsV2()).setComponents(((ContainerBuilder)message2).build()) : (MessageCreateBuilder)new MessageCreateBuilder().setContent((String)message2)));
        MessageEditBuilder editBuilder = (MessageEditBuilder)new MessageEditBuilder().applyCreateData(builder.build());
        if (e instanceof InteractionEvent && (interaction = ((InteractionEvent)e).getInteractionEvent().getInteraction()) instanceof ComponentInteraction) {
            ComponentInteraction componentInteraction = (ComponentInteraction)interaction;
            if (((ComponentInteraction)((InteractionEvent)e).getInteractionEvent().getInteraction()).getMessageId().equals(((Message)target).getId()) && !this.direct) {
                try {
                    if (componentInteraction.isAcknowledged()) {
                        SkriptUtils.error(this.node, "You're trying to edit a message's interaction, but you already acknowledged it! You may want to use the 'direct' option to edit the message itself!");
                        return;
                    }
                    ((MessageEditCallbackAction)componentInteraction.editMessage(editBuilder.build()).setReplace(this.replace)).complete();
                }
                catch (Exception ex) {
                    DiSkyRuntimeHandler.error(ex, this.node);
                }
                return;
            }
        }
        try {
            if (target instanceof Message) {
                Message targetMsg = (Message)target;
                @Nullable RegisteredWebhook authorWebhook = DiSky.getWebhooksManager().getWebhookById(targetMsg.getAuthor().getId());
                if (authorWebhook == null) {
                    ((MessageEditAction)((Message)target).editMessage(editBuilder.build()).setReplace(this.replace)).complete();
                } else {
                    ((WebhookMessageEditAction)authorWebhook.getClient().editMessageById(targetMsg.getId(), editBuilder.build()).setReplace(this.replace)).complete();
                }
            }
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex, this.node);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "edit the message/interaction " + this.exprTarget.toString(e, debug) + " with " + this.exprMessage.toString(e, debug);
    }

    static {
        Skript.registerEffect(EditMessage.class, (String[])new String[]{"edit [replace:([and] replace|[by] replacing)] [:direct] [the] [message] %message% (with|to show) %string/messagecreatebuilder/embedbuilder/container%"});
    }
}

