/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Kick Member")
@Description(value={"Kick a specific member out of its guild. You can also specify a reason if needed."})
@Examples(value={"kick discord event-member due to \"ur bad guys!\""})
public class KickMember
extends AsyncEffect {
    private Expression<Member> exprMember;
    private Expression<String> exprReason;

    public boolean init(Expression @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprMember = exprs[0];
        this.exprReason = exprs[1];
        return true;
    }

    public void execute(@NotNull Event e) {
        Member member = (Member)this.exprMember.getSingle(e);
        @Nullable String reason = EasyElement.parseSingle(this.exprReason, e, null);
        if (member == null) {
            return;
        }
        try {
            member.kick().reason(reason).complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "kick " + this.exprMember.toString(e, debug) + (String)(this.exprReason != null ? " because of " + this.exprReason.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(KickMember.class, (String[])new String[]{"kick [the] discord [member] %member% [(due to|because of|with [the] reason) %-string%]"});
    }
}

