/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Load Members")
@Description(value={"Load every members of a guild.", "This effect will also cache members that were not, so execution may be delayed.", "consider calling this effect once, then use the default member expression to get the members."})
@Examples(value={"load members of event-guild and store them in {_members::*}"})
@Since(value={"4.0.0"})
public class LoadMembers
extends AsyncEffect {
    private Expression<Guild> exprGuild;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprGuild = expressions[0];
        this.exprResult = expressions[1];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Member[].class});
    }

    public void execute(@NotNull Event e) {
        List<Member> members;
        Guild guild = EasyElement.parseSingle(this.exprGuild, e, null);
        if (guild == null) {
            return;
        }
        try {
            members = guild.loadMembers().get();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        this.exprResult.change(e, (Object[])members.toArray(new Member[0]), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "load members of " + this.exprGuild.toString(e, debug) + " and store them in " + this.exprResult.toString(e, debug);
    }

    static {
        Skript.registerEffect(LoadMembers.class, (String[])new String[]{"load [all] members (of|from) [the] %guild% and store (them|the members) in %~objects%"});
    }
}

