/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.managers.channel.concrete.ThreadChannelManager;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Lock / Unlock Thread")
@Description(value={"Lock or unlock a specific thread."})
@Examples(value={"lock event-threadchannel", "unlock thread channel with id \"000\""})
@Since(value={"4.4.0"})
public class LockUnlockThread
extends AsyncEffect {
    private Expression<ThreadChannel> exprThread;
    private boolean lock;

    public boolean init(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprThread = expressions[0];
        this.lock = i == 0;
        return true;
    }

    public void execute(@NotNull Event e) {
        ThreadChannel thread = EasyElement.parseSingle(this.exprThread, e);
        if (thread == null) {
            return;
        }
        ThreadChannelManager manager = thread.getManager();
        try {
            manager.setLocked(this.lock).complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return (this.lock ? "lock" : "unlock") + " the thread " + this.exprThread.toString(e, debug);
    }

    static {
        Skript.registerEffect(LockUnlockThread.class, (String[])new String[]{"lock [the] [thread] %threadchannel%", "unlock [the] [thread] %threadchannel%"});
    }
}

