/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.PrivateChannel;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Open Private Channel")
@Description(value={"Opens a private channel with a specific user.", "The channel will be null if the id is not valid or if the target is the bot", "WARNING: THIS DOESNT RETURN NULL WHEN THE USER BLOCKED THE BOT OR IS NOT ABLE TO SEND THE USER A MESSAGE"})
@Examples(value={"open private channel of event-user and store it in {_channel}"})
public class OpenPrivateChannel
extends AsyncEffect {
    private Expression<User> exprUser;
    private Expression<Object> exprResult;
    private Node node;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.node = this.getParser().getNode();
        this.exprUser = exprs[0];
        this.exprResult = exprs[1];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{PrivateChannel.class});
    }

    public void execute(@NotNull Event e) {
        User rawUser = EasyElement.parseSingle(this.exprUser, e, null);
        DiSky.debug("Opening private channel of user " + (rawUser == null ? "[user not set]" : rawUser.getId()) + " ...");
        if (rawUser == null) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprUser);
            return;
        }
        try {
            PrivateChannel channel = (PrivateChannel)rawUser.openPrivateChannel().complete();
            if (channel == null) {
                DiSkyRuntimeHandler.error(new IllegalStateException("The private channel of user " + rawUser.getId() + " is null!"), this.node);
                this.exprResult.change(e, new Object[0], Changer.ChangeMode.SET);
                return;
            }
            this.exprResult.change(e, new Object[]{channel}, Changer.ChangeMode.SET);
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex, this.node);
            this.exprResult.change(e, new Object[0], Changer.ChangeMode.SET);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "open private message of " + this.exprUser.toString(e, debug) + " and store it in " + this.exprResult.toString(e, debug);
    }

    static {
        Skript.registerEffect(OpenPrivateChannel.class, (String[])new String[]{"open [the] private (channel|message[s]) of [the] [member] %user% and store (it|the [private] channel) in %objects%"});
    }
}

