/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateRequest;
import net.dv8tion.jda.api.utils.messages.MessagePollBuilder;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.componentsv2.base.ContainerBuilder;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import okhttp3.MediaType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Post Message")
@Description(value={"Posts a message to a message-channel.", "You can send messages in a text, private, news, post or thread channel."})
@Examples(value={"post \"Hello world!\" to text channel with id \"000\"", "post last embed to thread channel with id \"000\" and store it in {_message}"})
@Since(value={"4.4.0"})
public class PostMessage
extends AsyncEffect {
    private static final long MAX_FILE_SIZE = 0x1900000L;
    private static final int REQUIRED_SAMPLE_RATE = 48000;
    private static final double MAX_DURATION = 60.0;
    private static final double MIN_DURATION = 1.0;
    private static final int MAX_WAVEFORM_POINTS = 256;
    private Expression<Object> exprMessage;
    private Expression<Channel> exprChannel;
    private Expression<Bot> exprBot;
    private Expression<Message> exprReference;
    private Expression<Object> exprResult;
    private Node node;
    private boolean isVoiceMessage;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.node = this.getParser().getNode();
        this.isVoiceMessage = matchedPattern == 1;
        this.exprMessage = expressions[0];
        this.exprChannel = expressions[1];
        this.exprBot = expressions[2];
        if (!this.isVoiceMessage) {
            this.exprReference = expressions[3];
            this.exprResult = expressions[4];
        } else {
            this.exprReference = null;
            this.exprResult = expressions[3];
        }
        return this.exprResult == null || Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Message.class});
    }

    public void execute(@NotNull Event e) {
        Message finalMessage;
        MessageCreateAction action;
        Object message2 = this.exprMessage.isSingle() ? EasyElement.parseSingle(this.exprMessage, e) : null;
        Object[] rawUploads = !this.exprMessage.isSingle() ? this.exprMessage.getArray(e) : null;
        Channel channel = EasyElement.parseSingle(this.exprChannel, e);
        @Nullable Message reference = EasyElement.parseSingle(this.exprReference, e);
        Bot bot = Bot.fromContext(this.exprBot, e);
        if (message2 == null && (rawUploads == null || rawUploads.length == 0)) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("Given message or file uploads is empty or invalid."), this.node, false);
            return;
        }
        if (!DiSkyRuntimeHandler.checkSet(this.node, this.exprChannel, channel)) {
            return;
        }
        if (!MessageChannel.class.isAssignableFrom(channel.getClass())) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The specified channel must be a message channel. (got a " + channel.getClass().getSimpleName() + ")"), this.node, false);
            return;
        }
        if (this.isVoiceMessage) {
            this.handleVoiceMessage((String)message2, (MessageChannel)channel, e);
            return;
        }
        if (message2 instanceof Sticker) {
            MessageChannel messageChannel = (MessageChannel)channel;
            if (!(messageChannel instanceof GuildMessageChannel)) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("Stickers can only be sent in guild message channels."), this.node, false);
                return;
            }
            action = ((GuildMessageChannel)messageChannel).sendStickers((Sticker)message2);
        } else {
            MessageCreateRequest<MessageCreateBuilder> builder;
            if (rawUploads != null) {
                ArrayList<FileUpload> uploads = new ArrayList<FileUpload>();
                for (Object upload : rawUploads) {
                    uploads.add((FileUpload)upload);
                }
                builder = new MessageCreateBuilder().addFiles(uploads);
            } else {
                builder = message2 instanceof MessageCreateBuilder ? (MessageCreateBuilder)message2 : (message2 instanceof EmbedBuilder ? (MessageCreateBuilder)new MessageCreateBuilder().addEmbeds(((EmbedBuilder)message2).build()) : (message2 instanceof MessagePollBuilder ? new MessageCreateBuilder().setPoll(((MessagePollBuilder)message2).build()) : (message2 instanceof ContainerBuilder ? (MessageCreateBuilder)((MessageCreateBuilder)new MessageCreateBuilder().useComponentsV2()).setComponents(((ContainerBuilder)message2).build()) : (MessageCreateBuilder)new MessageCreateBuilder().setContent((String)message2))));
            }
            action = ((MessageChannel)channel).sendMessage(((MessageCreateBuilder)builder).build());
            if (reference != null) {
                action = action.setMessageReference(reference);
            }
            if (((MessageCreateBuilder)builder).getPoll() != null) {
                action = (MessageCreateAction)action.setPoll(((MessageCreateBuilder)builder).getPoll());
            }
        }
        try {
            finalMessage = (Message)action.complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex, this.node);
            return;
        }
        if (this.exprResult == null) {
            return;
        }
        this.exprResult.change(e, new Object[]{finalMessage}, Changer.ChangeMode.SET);
    }

    private void handleVoiceMessage(String filePath, MessageChannel channel, Event e) {
        try {
            File file = new File(filePath);
            if (!file.exists() || !file.isFile()) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("The file at path '" + filePath + "' doesn't exist or isn't a file!"), this.node, false);
                return;
            }
            if (file.length() > 0x1900000L) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("File size exceeds Discord's limit of 25MB!"), this.node, false);
                return;
            }
            if (!filePath.toLowerCase().endsWith(".wav")) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("Only WAV files are supported for voice messages!"), this.node, false);
                return;
            }
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
            AudioFormat format = audioInputStream.getFormat();
            long frames = audioInputStream.getFrameLength();
            double duration = (float)frames / format.getFrameRate();
            if (duration < 1.0 || duration > 60.0) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("Voice message duration must be between 1 and 60 seconds! Current duration: " + String.format("%.2f", duration) + " seconds"), this.node, false);
                return;
            }
            if (format.getSampleRate() != 48000.0f) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("Voice message must have a sample rate of 48000Hz! Current sample rate: " + format.getSampleRate() + "Hz"), this.node, false);
                return;
            }
            if (format.getChannels() != 1) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("Voice message must be mono (1 channel)! Current channels: " + format.getChannels()), this.node, false);
                return;
            }
            byte[] audioData = Files.readAllBytes(file.toPath());
            byte[] waveform = PostMessage.generateWaveform(audioData, 256);
            FileUpload voiceUpload = FileUpload.fromData(file).asVoiceMessage(MediaType.parse("audio/wav"), waveform, duration);
            Message finalMessage = (Message)channel.sendFiles(voiceUpload).complete();
            if (this.exprResult != null) {
                this.exprResult.change(e, new Object[]{finalMessage}, Changer.ChangeMode.SET);
            }
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex, this.node);
        }
    }

    private static byte[] generateWaveform(byte[] audioData, int numPoints) {
        numPoints = Math.min(numPoints, 256);
        byte[] waveform = new byte[numPoints];
        int samplesPerPoint = audioData.length / numPoints;
        int minSamplesPerPoint = 4800;
        samplesPerPoint = Math.max(samplesPerPoint, minSamplesPerPoint);
        for (int i = 0; i < numPoints; ++i) {
            int startIndex = i * samplesPerPoint;
            int endIndex = Math.min(startIndex + samplesPerPoint, audioData.length);
            int sum = 0;
            for (int j = startIndex; j < endIndex; ++j) {
                sum += Math.abs(audioData[j]);
            }
            waveform[i] = (byte)(sum / samplesPerPoint & 0xFF);
        }
        return waveform;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "post " + (this.isVoiceMessage ? "voice message " : "") + this.exprMessage.toString(e, debug) + " to " + this.exprChannel.toString(e, debug) + (String)(this.exprResult == null ? "" : " and store it in " + this.exprResult.toString(e, debug));
    }

    static {
        Skript.registerEffect(PostMessage.class, (String[])new String[]{"(post|dispatch) %fileuploads/string/messagecreatebuilder/sticker/embedbuilder/messagepollbuilder/container% (in|to) [the] %channel% [(using|with) [the] [bot] %-bot%] [with [the] reference[d] [message] %-message%] [and store (it|the message) in %-~objects%]", "(post|dispatch) voice message %string% (in|to) [the] %channel% [(using|with) [the] [bot] %-bot%] [and store (it|the message) in %-~objects%]"});
    }
}

