/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.itsthesky.disky.api.skript.SpecificBotEffect;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Purge Messages")
@Description(value={"Discord provide a better way to delete multiple messages at once.", "This effect only works with messages, and a list is recommended here.", "If you want to delete a single message, use the destroy effect."})
@Examples(value={"retrieve last 50 messages from event-channel and store them in {_msg::*}", "purge {_msg::*}"})
public class PurgeMessages
extends SpecificBotEffect {
    private Expression<Message> exprMessages;

    @Override
    public void runEffect(@NotNull Event e, Bot bot) {
        Message[] messages = PurgeMessages.parseList(this.exprMessages, e, new Message[0]);
        if (messages.length <= 0) {
            return;
        }
        HashMap<MessageChannel, List> sorted2 = new HashMap<MessageChannel, List>();
        for (Message message2 : messages) {
            if (!sorted2.containsKey(message2.getChannel())) {
                sorted2.put(message2.getChannel(), new ArrayList());
            }
            ((List)sorted2.get(message2.getChannel())).add(message2);
        }
        sorted2.forEach(MessageChannel::purgeMessages);
        this.restart();
    }

    @Override
    public boolean initEffect(Expression[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.exprMessages = expressions[0];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "purge " + this.exprMessages.toString(e, debug);
    }

    static {
        Skript.registerEffect(PurgeMessages.class, (String[])new String[]{"purge [the] [message[s]] %messages%"});
    }
}

