/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.api.utils.messages.MessagePollBuilder;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import net.itsthesky.disky.api.events.specific.InteractionEvent;
import net.itsthesky.disky.api.events.specific.MessageEvent;
import net.itsthesky.disky.api.skript.AsyncEffectSection;
import net.itsthesky.disky.api.skript.BetterExpressionEntryData;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.components.core.ComponentRow;
import net.itsthesky.disky.elements.componentsv2.base.ContainerBuilder;
import net.itsthesky.disky.elements.effects.DeferInteraction;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Reply With")
@Description(value={"Reply with a specific message to the channel where a message-event was triggered.", "It can also be used to acknowledge & reply to an interaction, such as button click or slash command.", "In interaction only, you can use the keyword 'hidden' to reply with an ephemeral message (only the executor can see it).", "Therefore, the value stored in the variable, if specified, will be an interaction hook, and not a compete message.", "You can also provide a message as reference. The replied message be linked with the provided one."})
@Examples(value={"reply with \"Hello world!\"", "reply with last embed with reference event-message", "reply with hidden \"Hello ...\" and store it in {_msg}\nwait a second", "edit {_msg} to show \"... world!\""})
@Since(value={"4.4.0"})
public class ReplyWith
extends AsyncEffectSection {
    private static final EntryValidator ReplySectionValidator;
    private Node node;
    private Expression<Object> exprMessage;
    private Expression<Message> exprReference;
    private Expression<Object> exprResult;
    private boolean hidden;
    @Nullable
    private SectionNode sectionNode;
    @Nullable
    private Expression<?> secExprContent;
    @Nullable
    private Expression<?> secExprEmbed;
    @Nullable
    private Expression<?> secExprPoll;
    @Nullable
    private List<Expression<?>> secExprComponents;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!EasyElement.containsInterfaces(MessageEvent.class)) {
            Skript.error((String)"The effect reply effect can only be used in a message event.");
            return false;
        }
        this.node = this.getParser().getNode();
        this.hidden = parseResult.expr.startsWith("reply with hidden");
        this.exprMessage = expressions[0];
        this.exprReference = expressions[1];
        this.exprResult = expressions[2];
        if (sectionNode != null) {
            this.sectionNode = sectionNode;
            EntryContainer validatedEntries = ReplySectionValidator.validate(sectionNode);
            if (validatedEntries == null) {
                return false;
            }
            this.secExprContent = (Expression)validatedEntries.getOptional("content", Expression.class, true);
            this.secExprEmbed = (Expression)validatedEntries.getOptional("embed", Expression.class, true);
            this.secExprPoll = (Expression)validatedEntries.getOptional("poll", Expression.class, true);
            this.secExprComponents = (List)validatedEntries.getOptional("components", List.class, true);
        }
        return this.exprResult == null || Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Message.class});
    }

    private MessageCreateBuilder parseAdditionalData(Event event) {
        Object poll;
        Object content;
        if (this.sectionNode == null) {
            return new MessageCreateBuilder();
        }
        MessageCreateBuilder builder = new MessageCreateBuilder();
        if (this.secExprContent != null && (content = EasyElement.parseSingle(this.secExprContent, event)) instanceof String) {
            Object[] string = (Object[])content;
            builder.setContent((String)string);
        }
        if (this.secExprEmbed != null) {
            Object[] embeds;
            for (Object embed2 : embeds = EasyElement.parseList(this.secExprEmbed, event, new Object[0])) {
                if (!(embed2 instanceof EmbedBuilder)) continue;
                EmbedBuilder embedBuilder = (EmbedBuilder)embed2;
                builder.addEmbeds(embedBuilder.build());
            }
        }
        if (this.secExprPoll != null && (poll = EasyElement.parseSingle(this.secExprPoll, event)) instanceof MessagePollBuilder) {
            MessagePollBuilder pollBuilder = (MessagePollBuilder)poll;
            builder.setPoll(pollBuilder.build());
        }
        if (this.secExprComponents != null) {
            ArrayList<ComponentRow> rows = new ArrayList<ComponentRow>();
            for (Expression<?> secExprComponent : this.secExprComponents) {
                Object[] rawComponents = EasyElement.parseList(secExprComponent, event, new Object[0]);
                ComponentRow row2 = new ComponentRow(Arrays.asList(rawComponents));
                if (row2.isEmpty()) continue;
                rows.add(row2);
            }
            builder.setComponents(rows.stream().map(ComponentRow::asActionRow).toList());
        }
        return builder;
    }

    @Override
    public void execute(@NotNull Event e) {
        Object message2 = EasyElement.parseSingle(this.exprMessage, e);
        Message reference = EasyElement.parseSingle(this.exprReference, e);
        if (message2 == null) {
            return;
        }
        MessageRequest<MessageCreateAction> messageRestAction = null;
        RestAction otherRestAction = null;
        if (message2 instanceof Sticker) {
            MessageEvent event = (MessageEvent)e;
            if (!(event.getMessageChannel() instanceof GuildMessageChannel)) {
                SkriptUtils.error(this.node, "You can't reply with a sticker in a guild channel!");
                return;
            }
            messageRestAction = ((GuildMessageChannel)event.getMessageChannel()).sendStickers((Sticker)message2).setMessageReference(reference);
        } else {
            MessageCreateBuilder builder;
            if (message2 instanceof MessageCreateBuilder) {
                builder = (MessageCreateBuilder)message2;
            } else if (message2 instanceof EmbedBuilder) {
                builder = (MessageCreateBuilder)this.parseAdditionalData(e).addEmbeds(((EmbedBuilder)message2).build());
            } else if (message2 instanceof MessagePollBuilder) {
                builder = this.parseAdditionalData(e).setPoll(((MessagePollBuilder)message2).build());
            } else if (message2 instanceof ContainerBuilder) {
                ContainerBuilder containerBuilder = (ContainerBuilder)message2;
                builder = (MessageCreateBuilder)((MessageCreateBuilder)new MessageCreateBuilder().useComponentsV2()).addComponents((MessageTopLevelComponent)containerBuilder.buildWithId());
            } else {
                builder = (MessageCreateBuilder)this.parseAdditionalData(e).setContent((String)message2);
            }
            if (!builder.isValid()) {
                SkriptUtils.error(this.node, "The provided message is not valid!");
                return;
            }
            if (e instanceof InteractionEvent) {
                event = (InteractionEvent)e;
                if (!(event.getInteractionEvent().getInteraction() instanceof IReplyCallback)) {
                    SkriptUtils.error(this.node, "You are trying to reply or defer an interaction that is not a reply callback!");
                    return;
                }
                IReplyCallback callback = (IReplyCallback)event.getInteractionEvent().getInteraction();
                if (DeferInteraction.WAITING_INTERACTIONS.contains(callback.getHook().getInteraction().getIdLong())) {
                    DeferInteraction.WAITING_INTERACTIONS.remove(callback.getHook().getInteraction().getIdLong());
                    messageRestAction = callback.getHook().editOriginal(MessageEditData.fromCreateData(builder.build()));
                } else {
                    if (event.getInteractionEvent().getInteraction().isAcknowledged()) {
                        SkriptUtils.error(this.node, "You are trying to reply or defer an interaction that has already been acknowledged!");
                        return;
                    }
                    otherRestAction = callback.reply(builder.build()).setEphemeral(this.hidden);
                }
            } else {
                event = (MessageEvent)e;
                messageRestAction = event.getMessageChannel().sendMessage(builder.build());
                if (reference != null) {
                    messageRestAction.setMessageReference(reference);
                }
            }
        }
        if (messageRestAction != null) {
            Message result2;
            try {
                result2 = (Message)messageRestAction.complete();
            }
            catch (Exception ex) {
                DiSkyRuntimeHandler.error(ex, this.node);
                return;
            }
            if (this.exprResult != null) {
                this.exprResult.change(e, (Object[])new Message[]{result2}, Changer.ChangeMode.SET);
            }
        }
        if (otherRestAction != null) {
            InteractionHook interactionHook;
            try {
                interactionHook = (InteractionHook)otherRestAction.complete();
            }
            catch (Exception ex) {
                DiSkyRuntimeHandler.error(ex, this.node);
                return;
            }
            if (this.exprResult != null) {
                Message hookMessage = interactionHook.retrieveOriginal().complete();
                this.exprResult.change(e, (Object[])new Message[]{hookMessage}, Changer.ChangeMode.SET);
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "reply with " + this.exprMessage.toString(e, debug) + (this.hidden ? " hidden" : "") + (String)(this.exprReference != null ? " with reference " + this.exprReference.toString(e, debug) : "") + (String)(this.exprResult != null ? " and store it in " + this.exprResult.toString(e, debug) : "");
    }

    static {
        Skript.registerSection(ReplyWith.class, (String[])new String[]{"reply with [hidden] %string/messagecreatebuilder/sticker/embedbuilder/messagepollbuilder/containers% [with [the] reference[d] [message] %-message%] [and store (it|the message) in %-objects%]"});
        ReplySectionValidator = EntryValidator.builder().addEntryData((EntryData)new ExpressionEntryData("content", null, true, Object.class)).addEntryData((EntryData)new ExpressionEntryData("embed", null, true, Object.class)).addEntryData((EntryData)new ExpressionEntryData("poll", null, true, Object.class)).addEntryData(new BetterExpressionEntryData<Object>("components", null, true, Object.class)).build();
    }
}

